//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA512.h
 * @brief		SHA512 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA512_H_
#define INCG_IRIS_MathSHA512_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// define
//! SHA512nbVTCY
static const int SHA512_HASHSIZE_IN		= 64;
//! SHA512nbVTCY
static const int SHA512_HASHSIZE		= 64;
//! SHA512bZ[Wobt@TCY
static const int SHA512_LENGTHBUFSIZE	= 16;
//! SHA512bZ[WubNTCY
static const int SHA512_MSGBLKSIZE		= 128;

//======================================================================
// struct
//! SHA512pReLXg
typedef struct tagSHA512CONTEXT
{
#ifdef	_IRIS_NOT_SUPPORT_LLONG
	u32	uState[SHA512_HASHSIZE_IN>>2];		//!< nbV
	u32 uCount[SHA512_LENGTHBUFSIZE>>2];	//!< bZ[W
#else
	u64 uState[SHA512_HASHSIZE_IN>>3];		//!< nbV
	u64 uCount[SHA512_LENGTHBUFSIZE>>3];	//!< bZ[W
#endif
	u16	uIndex;							//!< obt@CfbNX
	u8	uBuffer[SHA512_MSGBLKSIZE];		//!< bZ[WubN
} SHA512CONTEXT, *LPSHA512CONTEXT;		//!< SHA512pReLXg
typedef const SHA512CONTEXT	*LPCSHA512CONTEXT;

//! SHA512nbVo͌^
typedef struct tagSHA512DIGEST
{
	u8	hash[SHA512_HASHSIZE];		//!< obt@
} SHA512DIGEST, LPSHA512DIGEST;	//!< SHA512nbVo͌^

//======================================================================
// function
// SHA512pReLXg̏
void	SHA512InitContext(LPSHA512CONTEXT lpContext);
// SHA512pReLXg̃NA
void	SHA512ClearContext(LPSHA512CONTEXT lpContext);
// SHA512vZ
void	SHA512Update(LPSHA512CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// ŏIISHA512vZ
void	SHA512Final(LPSHA512CONTEXT lpContext);
// SHA512o
void	SHA512Output(LPCSHA512CONTEXT lpContext, u8* lpBuffer);

// SHA512܂Ƃ߂ČvZ
void	SHA512Encode(LPSHA512CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
void	SHA512Encode(u8* lpDst, const u8* lpBuffer, u32 uLength);

// SHA512o͒l𕶎ɕϊ
LPTSTR	SHA512ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA512);
LPSTR	SHA512ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA512);
LPWSTR	SHA512ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA512);


// template
/**
 * @brief	SHA512vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA512Update(LPSHA512CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA512Update(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA512܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA512Encode(LPSHA512CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA512Encode(lpContext, pointer_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA512܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA512Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA512Encode(lpDst, pointer_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
