//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathCRC32R.h
 * @brief		CRC32 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathCRC32R_H_
#define INCG_IRIS_MathCRC32R_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// function
// CRC32e[u̍쐬iEj
bool	CRC32RMakeTable(u32* pDst, u32 nSize, u32 uPoly);

// CRC32vZiEj
u32		CRC32RUpdate(const u8* lpBuffer, u32 uLength, u32 uFirst=0xFFFFFFFF, u32 uXor=0);
u32		CRC32RUpdate(const u8* lpBuffer, u32 uLength, const u32* lpTable, u32 uFirst=0xFFFFFFFF, u32 uXor=0);

}	// end of namespace math
}	// end of namespace iris

#endif
