//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathCRC32L.cpp
 * @brief		CRC32 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathCRC32L_CPP_

//======================================================================
// include
#include "MathCRC32L.h"

namespace iris {
namespace math
{

//======================================================================
// function
/**********************************************************************//**
 *
 * CRC32e[u̍쐬ij
 *
 ----------------------------------------------------------------------
 * @param [out]	pDst	= o̓obt@
 * @param [in]	nSize	= o̓obt@TCY
 * @param [in]	uPoly	= 
 * @return	
*//***********************************************************************/
bool	CRC32LMakeTable(u32* pDst, u32 nSize, u32 uPoly)
{
	if( pDst == nullptr ) return false;
	if( nSize < 256*sizeof(u32) ) return false;
	if( uPoly == 0 ) return false;
	u32* dst = pDst;
	for( u32 i=0; i < 256; ++i, ++dst )
	{
		u32 crc = i<<24;
		for( int j=0; j < 8; ++j )
		{
			if( crc & 0x80000000 )	crc = (crc << 1) ^ uPoly;
			else					crc <<= 1;
		}
		*dst = crc;
	}
	return true;
}

/**********************************************************************//**
 *
 * CRC32vZij
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
 * @param [in]	uFirst		= l
 * @param [in]	uXor		= o͑Oxorl
 * @return	o͒l
*//***********************************************************************/
u32	CRC32LUpdate(const u8* lpBuffer, u32 uLength, u32 uFirst, u32 uXor)
{
	static const u32 crc_table[256] =
	{
#include "crc32tblL.inc"
	};
	return CRC32LUpdate(lpBuffer, uLength, crc_table, uFirst, uXor);
}

/**********************************************************************//**
 *
 * CRC32vZij
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@
 * @param [in]	uFirst		= l
 * @param [in]	uXor		= o͑Oxorl
 * @return	o͒l
*//***********************************************************************/
u32	CRC32LUpdate(const u8* lpBuffer, u32 uLength, const u32* lpTable, u32 uFirst, u32 uXor)
{
	u32 crc = uFirst;
	for( u32 i=0; i < uLength; ++i, ++lpBuffer )
	{
		crc = lpTable[((crc>>24) ^ (*lpBuffer))&0xFF] ^ (crc << 8);
	}
	return crc ^ uXor;
}

}	// end of namespace math
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathCRC32LUnitTest, Func)
{
	IrisU32 poly=0;
	IrisU32 table[256];
	std::clog << "CRCe[ȕóij" << std::endl;
	std::clog << "͂Ă" << std::endl;
	std::safe_cin >> poly;

	if( !CRC32LMakeTable(table, sizeof(table), poly) ) return;

	for( int i=0; i < 32; ++i )
	{
		for( int j=0; j < 8; ++j )
		{
			printf("0x%.8x, ",  table[i*8+j]);
		}
		std::cout << std::endl;
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
