//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPlane.inl
 * @brief		ʉZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPlane_inl_
#define INCG_IRIS_MathPlane_inl_

namespace iris {
namespace math
{

//======================================================================
// function
/**
 * @brief	ʂ̐
 * @param [out]	pl0	= o͕
 * @param [in]	a	= vfa
 * @param [in]	b	= vfb
 * @param [in]	c	= vfc
 * @param [in]	d	= vfd
 * @return	o͕
*/
IRIS_FPU_INLINE IrisFPlane*	FpuPlaneSet(IrisFPlane* pl0, f32 a, f32 b, f32 c, f32 d)
{
	MATH_FPU_NULLASSERT( pl0 );
	pl0->a = a;
	pl0->b = b;
	pl0->c = c;
	pl0->d = d;
	return pl0;
}

/**
 * @brief	ʂ̃Rs[
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
IRIS_FPU_INLINE IrisFPlane*	FpuPlaneCopy(IrisFPlane* pl0, const IrisFPlane* pl1)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	pl0->a = pl1->a;
	pl0->b = pl1->b;
	pl0->c = pl1->c;
	pl0->d = pl1->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̉Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 
 * @param [in]	pl2	= 
 * @return	o͕
*/
IRIS_FPU_INLINE IrisFPlane*	FpuPlaneAdd(IrisFPlane* pl0, const IrisFPlane* pl1, const IrisFPlane* pl2)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	MATH_FPU_NULLASSERT( pl2 );
	pl0->a = pl1->a + pl2->a;
	pl0->b = pl1->b + pl2->b;
	pl0->c = pl1->c + pl2->c;
	pl0->d = pl1->d + pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̌Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 팸
 * @param [in]	pl2	= 
 * @return	o͕
*/
IRIS_FPU_INLINE IrisFPlane*	FpuPlaneSub(IrisFPlane* pl0, const IrisFPlane* pl1, const IrisFPlane* pl2)
{
	MATH_FPU_NULLASSERT( pl0 );
	MATH_FPU_NULLASSERT( pl1 );
	MATH_FPU_NULLASSERT( pl2 );
	pl0->a = pl1->a - pl2->a;
	pl0->b = pl1->b - pl2->b;
	pl0->c = pl1->c - pl2->c;
	pl0->d = pl1->d - pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̖@1ɂȂ悤ɐK
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
IRIS_FPU_INLINE IrisFPlane*	FpuPlaneNormalize(IrisFPlane* pl0, const IrisFPlane* pl1)
{
	f32 a = pl1->a;
	f32 b = pl1->b;
	f32 c = pl1->c;
	f32 d = pl1->d;
	f32 q = F32_Div(1.0f, F32_Sqrt(F32_Mul(a, a) + F32_Mul(b, b) + F32_Mul(c, c)) );
	if(q!=0.0f) q = F32_Div(1.0f, q);

	pl0->a = F32_Mul(a, q);
	pl0->b = F32_Mul(b, q);
	pl0->c = F32_Mul(c, q);
	pl0->d = F32_Mul(d, q);
	return pl0;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
IRIS_FPU_INLINE f32			FpuPlaneVec3Distance(const IrisFPlane* pl0, const IrisFVec3* pv0)
{
	f32 n = F32_Sqrt( F32_Mul(pl0->a, pl0->a) + F32_Mul(pl0->b, pl0->b) + F32_Mul(pl0->c, pl0->c));
	f32 f = F32_Abs( F32_Div((F32_Mul(pl0->a, pv0->x) + F32_Mul(pl0->b, pv0->y) + F32_Mul(pl0->c, pv0->z) + pl0->d), n));
	return f;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
IRIS_FPU_INLINE f32			FpuPlaneVec4DistanceXYZ(const IrisFPlane* pl0, const IrisFVec4* pv0)
{
	f32 n = F32_Sqrt( F32_Mul(pl0->a, pl0->a) + F32_Mul(pl0->b, pl0->b) + F32_Mul(pl0->c, pl0->c));
	f32 f = F32_Abs( F32_Div((F32_Mul(pl0->a, pv0->x) + F32_Mul(pl0->b, pv0->y) + F32_Mul(pl0->c, pv0->z) + pl0->d), n));
	return f;
}

}	// end of namespace math
}	// end of namespace iris

#endif
