//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPerspective.h
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPerspective_H_
#define INCG_IRIS_MathPerspective_H_

//======================================================================
// include
#include "MathMatrix44.h"
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE	IrisFMtx44*		FpuLookAtMatrix(IrisFMtx44* pm0, const IrisFVec4* pvEye, const IrisFVec4* pvLookAt, const IrisFVec4* pvUp);
IRIS_FPU_INLINE	IrisFMtx44*		FpuPerspectiveMatrix(IrisFMtx44* pm0, f32 fovy, f32 aspect, f32 xfNear, f32 xfFar);
IRIS_FPU_INLINE	IrisFMtx44*		FpuOrthoMatrix(IrisFMtx44* pm0, f32 left, f32 top, f32 right, f32 bottom, f32 r_near, f32 r_far);
IRIS_FPU_INLINE	IrisFMtx44*		FpuFrustumMatrix(IrisFMtx44* pm0, f32 left, f32 top, f32 right, f32 bottom, f32 r_near, f32 r_far);
IRIS_FPU_INLINE	IrisFMtx44*		FpuCameraMatrix(IrisFMtx44* pm0, const IrisFVec4* pv, const IrisFVec4* pzd, const IrisFVec4* pyd);
IRIS_FPU_INLINE	IrisFMtx44*		FpuViewScreenMatrix(IrisFMtx44* pm0, f32 scrz, f32 ax, f32 ay, f32 cx, f32 cy
													, f32 zmin, f32 zmax, f32 nearz, f32 farz);
IRIS_FPU_INLINE	IrisFMtx44*		FpuDropShadowMatrix(IrisFMtx44* pm0, const IrisFVec4* lp, f32 a, f32 b, f32 c, int mode);
IRIS_FPU_INLINE	IrisFVec4*		FpuRotTransPers(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	int				FpuRotTransPersN(short* pXyz, int pitch, const IrisFMtx44* pm0, const IrisFVec4* pv0, int n);

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathPerspective.inl"
#endif

#endif
