//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMatrix44.h
 * @brief		4x4}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathMatrix44_H_
#define INCG_IRIS_MathMatrix44_H_

//======================================================================
// include
#include "MathFpuDef.h"
#include "MathMatrix33.h"
#include "MathVector4.h"
#include "MathPlane.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Unit(IrisFMtx44* pm0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Zero(IrisFMtx44* pm0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Copy(IrisFMtx44* pm0, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44SetTransfer(IrisFMtx44* pm0, const IrisFVec4* pv0);
IRIS_FPU_INLINE IrisFVec4*		FpuMtx44GetTransfer(IrisFVec4* pv0, const IrisFMtx44* pm0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Transfer(IrisFMtx44* pm0, const IrisFMtx44* pm1, const IrisFVec4* pv0);
IRIS_FPU_INLINE IrisFVec4*		FpuMtx44Transform(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1);
IRIS_FPU_INLINE IrisFVec4*		FpuMtx44TransformXYZ(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1);
IRIS_FPU_INLINE IrisFVec4*		FpuMtx44HomogeneousTransform(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Mul(IrisFMtx44* pm0, const IrisFMtx44* pm1, const IrisFMtx44* pm2);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Scale(IrisFMtx44* pm0, const IrisFMtx44* pm1, f32 s);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Transpose(IrisFMtx44* pm0, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotZ(IrisFMtx44* pm0, const IrisFMtx44* pm1, f32 rz);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotIdxZ(IrisFMtx44* pm0, const IrisFMtx44* pm1, u16 idz);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotY(IrisFMtx44* pm0, const IrisFMtx44* pm1, f32 ry);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotIdxY(IrisFMtx44* pm0, const IrisFMtx44* pm1, u16 idy);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotX(IrisFMtx44* pm0, const IrisFMtx44* pm1, f32 rx);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotIdxX(IrisFMtx44* pm0, const IrisFMtx44* pm1, u16 idx);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Rot(IrisFMtx44* pm0, const IrisFMtx44* pm1, const IrisFVec4* pv0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44RotIdx(IrisFMtx44* pm0, const IrisFMtx44* pm1, const IrisSVec4* pv0);
IRIS_FPU_INLINE IrisBool		FpuMtx44IsUnit(const IrisFMtx44* pm0);
IRIS_FPU_INLINE f32				FpuMtx44Trace(const IrisFMtx44* pm0);
IRIS_FPU_INLINE f32				FpuMtx44Determinant(const IrisFMtx44* pm0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Adjoint(IrisFMtx44* pm0, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Inverse(IrisFMtx44* pm0, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44Inverse2(IrisFMtx44* pm0, f32* pDeterminant, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44DropShadow(IrisFMtx44* pm0, const IrisFVec4* pv0, const IrisFPlane* pl0);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44NormalizeXYZ(IrisFMtx44* pm0, const IrisFMtx44* pm1);
IRIS_FPU_INLINE IrisFMtx44*		FpuMtx44TruncatePrecision24(IrisFMtx44* pm0, const IrisFMtx44* pm1);

//======================================================================
// inline
STATICINLINE IrisFMtx44*	FpuMtx44Identity(IrisFMtx44* pm0)			{ return FpuMtx44Unit(pm0); }
STATICINLINE IrisFMtx44*	FpuMtx44Null(IrisFMtx44* pm0)				{ return FpuMtx44Zero(pm0); }
STATICINLINE IrisFVec4*	FpuMtx44Apply(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1)		{ return FpuMtx44Transform(pv0, pm0, pv1); }
STATICINLINE IrisFVec4*	FpuMtx44ApplyXYZ(IrisFVec4* pv0, const IrisFMtx44* pm0, const IrisFVec4* pv1)	{ return FpuMtx44TransformXYZ(pv0, pm0, pv1); }
STATICINLINE IrisBool		FpuMtx44IsIdentity(const IrisFMtx44* pm0)	{ return FpuMtx44IsUnit(pm0); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathMatrix44.inl"
#endif

#endif
