//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathFpu.h
 * @brief		lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathFpu_H_
#define INCG_IRIS_MathFpu_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE f32			FpuAbs(f32 fs);
IRIS_FPU_INLINE s32			FpuCeil(f32 fs);
IRIS_FPU_INLINE s32			FpuFloor(f32 fs);
IRIS_FPU_INLINE f32			FpuMax(f32 a, f32 b);
IRIS_FPU_INLINE f32			FpuMin(f32 a, f32 b);
IRIS_FPU_INLINE f32			FpuNeg(f32 fs);
IRIS_FPU_INLINE s32			FpuRound(f32 fs);
IRIS_FPU_INLINE f32			FpuRsqrt(f32 fs);
IRIS_FPU_INLINE f32			FpuSqrt(f32 fs);
IRIS_FPU_INLINE s32			FpuTrunc(f32 fs);
IRIS_FPU_INLINE f32			FpuFmod(f32 fs, f32 fd);
IRIS_FPU_INLINE f32			FpuFrac(f32 fs);
IRIS_FPU_INLINE f32			FpuReinterpretFloat(u32 ui);
IRIS_FPU_INLINE u32			FpuReinterpretUint(f32 fs);
IRIS_FPU_INLINE IrisBool	FpuIsEqual(f32 fs1, f32 fs2);
IRIS_FPU_INLINE f32			FpuSignFloat(f32 fs);
IRIS_FPU_INLINE s32			FpuSignInt(f32 fs);
IRIS_FPU_INLINE f32			FpuPositiveZero(void);
IRIS_FPU_INLINE f32			FpuNegativeZero(void);
IRIS_FPU_INLINE IrisBool	FpuIsZero(f32 fs);
IRIS_FPU_INLINE IrisBool	FpuIsPositiveZero(f32 fs);
IRIS_FPU_INLINE IrisBool	FpuIsNegativeZero(f32 fs);
IRIS_FPU_INLINE s32			FpuIsDenormal(f32 fs);
IRIS_FPU_INLINE s32			FpuIsZeroOrDenormal(f32 fs);
IRIS_FPU_INLINE f32			FpuPositiveInf(void);
IRIS_FPU_INLINE f32			FpuNegativeInf(void);
IRIS_FPU_INLINE s32			FpuIsInf(f32 fs);
IRIS_FPU_INLINE f32			FpuPositiveNaN(void);
IRIS_FPU_INLINE f32			FpuNegativeNaN(void);
IRIS_FPU_INLINE f32			FpuPositiveQNaN(void);
IRIS_FPU_INLINE f32			FpuNegativeQNaN(void);
IRIS_FPU_INLINE f32			FpuPositiveSNaN(u32 signal);
IRIS_FPU_INLINE f32			FpuPositiveSNaNF(f32 signal);
IRIS_FPU_INLINE f32			FpuNegativeSNaN(u32 signal);
IRIS_FPU_INLINE f32			FpuNegativeSNaNF(f32 signal);
IRIS_FPU_INLINE s32			FpuIsNaN(f32 fs);
IRIS_FPU_INLINE s32			FpuIsInfOrNaN(f32 fs);
IRIS_FPU_INLINE f32			FpuNormalizePhase(f32 fs);
IRIS_FPU_INLINE f32			FpuSin(f32 fs);
IRIS_FPU_INLINE f32			FpuCos(f32 fs);
IRIS_FPU_INLINE f32			FpuAtan(f32 fs);
IRIS_FPU_INLINE f32			FpuAsin(f32 fs);
IRIS_FPU_INLINE f32			FpuAcos(f32 fs);
IRIS_FPU_INLINE f32			FpuLog(f32 fs);
IRIS_FPU_INLINE f32			FpuLog2(f32 fs);
IRIS_FPU_INLINE f32			FpuLog10(f32 fs);
IRIS_FPU_INLINE f32			FpuExp(f32 fs);
IRIS_FPU_INLINE f32			FpuExp2(f32 fs);
IRIS_FPU_INLINE f32			FpuExp10(f32 fs);
IRIS_FPU_INLINE f32			FpuPow(f32 x, f32 y);
IRIS_FPU_INLINE f64			FpuF32ToF64(f32 fs);
IRIS_FPU_INLINE f32			FpuF64ToF32(f64 fs);

//======================================================================
// inline
STATICINLINE f32	FpuZero(void)			{ return FpuPositiveZero(); }
STATICINLINE f32	FpuInf(void)			{ return FpuPositiveInf(); }
STATICINLINE f32	FpuNaN(void)			{ return FpuPositiveNaN(); }
STATICINLINE f32	FpuQNaN(void)			{ return FpuPositiveQNaN(); }
STATICINLINE f32	FpuSNaN(u32 signal)		{ return FpuPositiveSNaN(signal); }



}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathFpu.inl"
#endif

#endif
