//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPrimitivePolynomial.h
 * @brief		nNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPrimitivePolynomial_H_
#define INCG_IRIS_MathPrimitivePolynomial_H_

//======================================================================
// include
#include "../MathPower.h"
#include "../../iris_object.h"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"

namespace iris {
namespace math
{

//======================================================================
// class
/**
 * @brief	nNX
 * @tparam	_TN		= o͌^
*/
template<typename _TN>
class CPrimitivePolynomial : public IIrisObject
{
public:
	typedef _TN		value_type;
	typedef _TN*	value_ptr;
	typedef typename ::cpp0x::arg_type<_TN>::type arg_type;	//!< ^
private:
	value_type		m_Value;	//!< ̃rbgl
public:
	/// RXgN^
	CPrimitivePolynomial(void) : m_Value(1) {}
	/// RXgN^
	CPrimitivePolynomial(arg_type exp) : m_Value(1)
	{
		Calc(exp);
	}

public:
	/**
	 * @brief	Zo
	 * @param [in]	exp		= ׂw
	*/
	bool	Calc(arg_type exp)
	{
		return Calc<_TN>(exp);
	}
	/**
	 * @brief	Zo
	 * @tparam _TT	= vŽ^
	 * @param [in]	exp		= ׂw
	*/
	template<typename _TT>
	bool	Calc(arg_type exp)
	{
		// x^(2^exp-1)  1 mod f(x)
		// 0 < n < 2^exp - 1 𖞂nɂ
		// x^n  1 mod f(x)łȂ
		_TT v = (_TT)(1 << exp);
		_TT f = 0;
		for( _TT i=1; i < v; ++i )
		{
			f = v ^ i;
			_TT a=1, j=1;
			for( ; j < v; ++j )
			{
				a <<= 1;
				if( (a & v) == v )	a ^= f;
				if( a == 1 ) break;
			}
			if( j == (v-1) )
			{
				m_Value = (value_type)f;
				return true;
			}
		}
		return false;
	}

	/**
	 * @brief	Zo
	 * @param [in]	exp		= ׂw
	*/
	bool	Next(arg_type exp)
	{
		return Next<_TN>(exp);
	}

	/**
	 * @brief	Zo
	 * @tparam _TT	= vŽ^
	 * @param [in]	exp		= ׂw
	*/
	template<typename _TT>
	bool	Next(arg_type exp)
	{
		// x^(2^exp-1)  1 mod f(x)
		// 0 < n < 2^exp - 1 𖞂nɂ
		// x^n  1 mod f(x)łȂ
		_TT v = (_TT)1 << exp;
		_TT f = 0;
		for( _TT i=(v^m_Value)+1; i < v; ++i )
		{
			f = v ^ i;
			_TT a=1, j=1;
			for( ; j < v; ++j )
			{
				a <<= 1;
				if( (a & v) == v )	a ^= f;
				if( a == 1 ) break;
			}
			if( j == (v-1) )
			{
				m_Value = (value_type)f;
				return true;
			}
		}
		return false;
	}

public:
	/// 擾
	arg_type	operator() (void) const	{ return m_Value; }
	/// 擾
	arg_type	GetValue(void) const	{ return m_Value; }
};


}	// end of namespace math
}	// end of namespace iris

#endif
