//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathBezierCurve.h
 * @brief		xWGȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathBezierCurve_H_
#define INCG_IRIS_MathBezierCurve_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"
#include "../MathPractical.h"
#include "../MathPower.h"

namespace iris {
namespace math
{

//======================================================================
// function
// xWGȐ
f32	BezierCurve(f32 t, s32 n, ...);
// xWGȐ
f32	BezierCurveArray(f32 t, s32 n, f32 pt[]);

// NxNg̃xWGȐ
f32*	BezierCurveN(f32* pV, s32 N, f32 t, s32 n, ...);
// NxNg̃xWGȐ
f32*	BezierCurveArrayN(f32* pV, s32 N, f32 t, s32 n, f32 pt[]);

//======================================================================
// class
/**
 * @brief	xWGȐNX
*/
template<typename TN, size_t NUM_, size_t D>
class CBezierCurve : public IIrisObject
{
	typedef CBezierCurve<TN, NUM_, D>	_Myt;

protected:
	typedef IrisTVecN<TN, D>	value_type;
	typedef value_type			*value_ptr;
	typedef value_type			&value_ref;
public:
	IRIS_STATIC_ASSERT( D > 0 );
	static const size_t	POINTS_NUM	= NUM_;	//!< _̐
	static const size_t DIMENSION	= D;		//!< 

protected:
	value_type		m_Points[POINTS_NUM];	//!< _
public:
	// RXgN^
	CBezierCurve(void)	{}
	// RXgN^
	CBezierCurve(const value_ptr pPoints) { SetPoints(pPoints); }
	// fXgN^
	//~CBezierCurve(void);

public:
	/// _̐ݒ
	void		SetPoints(const value_ptr pPoints) { memcpy(m_Points, sizeof(m_Points), pPoints); }
	/// _̐ݒ
	void		SetPoint(int idx, const value_type& Point) { m_Points[idx] = Point; }
	/// _̎擾
	value_ref	GetPoint(int idx)	{ return m_Points[idx]; }
public:
	/// l̎擾
	value_type		GetValue(f32 time) const
	{
		value_type ret;
		if( time <= 0.0f )	return m_Points[0];
		if( time >= 1.0f )	return m_Points[POINTS_NUM-1];

		f32 tt = 1.0f;			// t^ip
		f32 it = 1.0f - time;	// (1-t)^ip
		s32 nn = POINTS_NUM-1;
		const value_type* pp = m_Points;
		for( s32 i=0; i < nn; ++i, ++pp )
		{
			value_type B(*pp);
			f32 J = Combination(nn, i) * (tt * F32_Pow(it, (f32)(nn-i)));
			for( int k=0; k < D; ++k )
			{
				ret.a[k] += B.a[k] * J;
			}
			tt = tt * time;
		}
		return ret;
	}
};

}	// end of namespace math
}	// end of namespace iris

#endif
