//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types.hpp
* @brief		iris ^`wb_(c++̂)
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_HPP_
#define INCG_IRIS_iris_types_HPP_

//======================================================================
// include
#include "iris_types.h"
#include "c++0x/cpp0x_attribute.hpp"
#include "c++0x/cpp0x_nullptr.h"	// nullptr
#include "types/iris_types_alias.h"
#include "types/iris_types_endian.h"
#include "types/iris_types_cast.hpp"
#include "types/iris_types_vector.hpp"
#include "types/iris_types_matrix.hpp"

#if defined(__cplusplus)

//======================================================================
// declare
struct IrisU24;
struct IrisS24;

template<typename _TN, _TN _FIXED>struct IrisFixedType;
template<typename _TN>struct IrisTRect;
template<typename _TN>struct IrisTQuaternion;
template<typename _TN>struct IrisTPlane;
template<typename _TN>struct IrisTRGBA;
template<typename _TN, IrisU32 _SIZE>struct IrisFixedArray;
class IrisVaugeBool;

//======================================================================
// struct
//!< 24bit signed ^
typedef struct IrisS24
{
	IrisU8	v[3];

	IrisS24(void)	{ v[0] = v[1] = v[2] = 0; }
	IrisS24(IrisS32	n)	{ v[0] = static_cast<IrisU8>(n&0xFF), v[1] = static_cast<IrisU8>((n>>8)&0xFF), v[2] = static_cast<IrisU8>((n>>16)&0x7F); v[2] |= static_cast<IrisU8>((n>>(31-8)) & 0x80); }
	IrisS24(const IrisS24& n)	{ v[0] = n.v[0], v[1] = n.v[1], v[2] = n.v[2]; }
	void	operator = (IrisS32 n)		{ v[0] = static_cast<IrisU8>(n&0xFF), v[1] = static_cast<IrisU8>((n>>8)&0xFF), v[2] = static_cast<IrisU8>((n>>16)&0x7F); v[2] |= static_cast<IrisU8>((n>>(31-8)) & 0x80); }
	operator IrisS32	(void)	const	{ return static_cast<IrisS32>(v[0]) | (static_cast<IrisS32>(v[1]) << 8) | ((static_cast<IrisS32>(v[2]) & 0x7F) << 16) | (static_cast<IrisS32>(v[2]) & 0x80) << 31; }
	IrisS24		operator << (int n)		{ IrisS32 x = *this; x <<= n; return x; }
	IrisS24		operator >> (int n)		{ IrisS32 x = *this; x >>= n; return x; }
	IrisS24&	operator <<= (int n)	{ IrisS32 x = *this; x <<= n; *this = x; return *this; }
	IrisS24&	operator >>= (int n)	{ IrisS32 x = *this; x >>= n; *this = x; return *this; }

	IrisS24&	operator |= (const IrisS24& n)	{ for( int i=0; i < 3; ++i ) { v[i] |= n.v[i]; } return *this; }
	IrisS24&	operator &= (const IrisS24& n)	{ for( int i=0; i < 3; ++i ) { v[i] &= n.v[i]; } return *this; }
	IrisS24&	operator ^= (const IrisS24& n)	{ for( int i=0; i < 3; ++i ) { v[i] ^= n.v[i]; } return *this; }

	IrisS24		operator | (const IrisS24& n)	const	{ IrisS24 ret(*this); ret |= n; return ret; }
	IrisS24		operator & (const IrisS24& n)	const	{ IrisS24 ret(*this); ret &= n; return ret; }
	IrisS24		operator ^ (const IrisS24& n)	const	{ IrisS24 ret(*this); ret ^= n; return ret; }

	IrisS24&	operator +=	(const IrisS24& n)	{ IrisS32 lhs = *this; IrisS32 rhs = n; lhs += rhs; *this = lhs; return *this; }
	IrisS24&	operator -=	(const IrisS24& n)	{ IrisS32 lhs = *this; IrisS32 rhs = n; lhs -= rhs; *this = lhs; return *this; }
	IrisS24&	operator /=	(const IrisS24& n)	{ IrisS32 lhs = *this; IrisS32 rhs = n; lhs /= rhs; *this = lhs; return *this; }
	IrisS24&	operator *=	(const IrisS24& n)	{ IrisS32 lhs = *this; IrisS32 rhs = n; lhs *= rhs; *this = lhs; return *this; }
	IrisS24&	operator %=	(const IrisS24& n)	{ IrisS32 lhs = *this; IrisS32 rhs = n; lhs %= rhs; *this = lhs; return *this; }

	IrisS24		operator +	(void)				const	{ return *this; }
	IrisS24		operator +	(const IrisS24& n)	const	{ IrisS24 ret(*this); ret += n; return ret; }
	IrisS24		operator -	(void)				const	{ IrisS32 ret = *this; ret = -ret; return ret; }
	IrisS24		operator -	(const IrisS24& n)	const	{ IrisS24 ret(*this); ret -= n; return ret; }
	IrisS24		operator /	(const IrisS24& n)	const	{ IrisS24 ret(*this); ret /= n; return ret; }
	IrisS24		operator *	(const IrisS24& n)	const	{ IrisS24 ret(*this); ret *= n; return ret; }
	IrisS24		operator %	(const IrisS24& n)	const	{ IrisS24 ret(*this); ret %= n; return ret; }

	IrisS24		operator ~ (void)	const	{ IrisS24 ret; for( int i=0; i < 3; ++i ) { ret.v[i] = static_cast<IrisU8>(~v[i]); } return ret; }
	bool		operator ! (void)	const	{ for( int i=0; i < 3; ++i ) { if( !v[i] ) return true; } return false; }

	bool		operator == (const IrisS24& n)	const	{ for( int i=0; i < 3; ++i ) { if( v[i] != n.v[i] ) return false; } return true; }
	bool		operator != (const IrisS24& n)	const	{ for( int i=0; i < 3; ++i ) { if( v[i] == n.v[i] ) return false; } return true; }
	bool		operator <  (const IrisS24& n)	const	{ IrisS32 lhs = *this; IrisS32 rhs = n; return lhs < rhs; }
	bool		operator >  (const IrisS24& n)	const	{ IrisS32 lhs = *this; IrisS32 rhs = n; return lhs > rhs; }
	bool		operator <= (const IrisS24& n)	const	{ IrisS32 lhs = *this; IrisS32 rhs = n; return lhs <= rhs; }
	bool		operator >= (const IrisS24& n)	const	{ IrisS32 lhs = *this; IrisS32 rhs = n; return lhs >= rhs; }

} IrisS24;

//!< 24bit unsigned ^
typedef struct IrisU24
{
	IrisU8	v[3];

	IrisU24(void)	{ v[0] = v[1] = v[2] = 0; }
	IrisU24(IrisU32	n)	{ v[0] = static_cast<IrisU8>(n&0xFF), v[1] = static_cast<IrisU8>((n>>8)&0xFF), v[2] = static_cast<IrisU8>((n>>16)&0xFF); }
	IrisU24(const IrisU24& n)	{ v[0] = n.v[0], v[1] = n.v[1], v[2] = n.v[2]; }
	void	operator = (IrisU32 n)		{ v[0] = static_cast<IrisU8>(n&0xFF), v[1] = static_cast<IrisU8>((n>>8)&0xFF), v[2] = static_cast<IrisU8>((n>>16)&0xFF); }
	operator IrisU32	(void)	const	{ return static_cast<IrisU32>(v[0]) | (static_cast<IrisU32>(v[1]) << 8) | (static_cast<IrisU32>(v[2]) << 16); }
	IrisU24		operator << (int n)		{ IrisU32 x = *this; x <<= n; return x; }
	IrisU24		operator >> (int n)		{ IrisU32 x = *this; x >>= n; return x; }
	IrisU24&	operator <<= (int n)	{ IrisU32 x = *this; x <<= n; *this = x; return *this; }
	IrisU24&	operator >>= (int n)	{ IrisU32 x = *this; x >>= n; *this = x; return *this; }

	IrisU24&	operator |= (const IrisU24& n)	{ for( int i=0; i < 3; ++i ) { v[i] |= n.v[i]; } return *this; }
	IrisU24&	operator &= (const IrisU24& n)	{ for( int i=0; i < 3; ++i ) { v[i] &= n.v[i]; } return *this; }
	IrisU24&	operator ^= (const IrisU24& n)	{ for( int i=0; i < 3; ++i ) { v[i] ^= n.v[i]; } return *this; }

	IrisU24		operator | (const IrisU24& n)	const	{ IrisU24 ret(*this); ret |= n; return ret; }
	IrisU24		operator & (const IrisU24& n)	const	{ IrisU24 ret(*this); ret &= n; return ret; }
	IrisU24		operator ^ (const IrisU24& n)	const	{ IrisU24 ret(*this); ret ^= n; return ret; }

	IrisU24&	operator +=	(const IrisU24& n)	{ IrisU32 lhs = *this; IrisU32 rhs = n; lhs += rhs; *this = lhs; return *this; }
	IrisU24&	operator -=	(const IrisU24& n)	{ IrisU32 lhs = *this; IrisU32 rhs = n; lhs -= rhs; *this = lhs; return *this; }
	IrisU24&	operator /=	(const IrisU24& n)	{ IrisU32 lhs = *this; IrisU32 rhs = n; lhs /= rhs; *this = lhs; return *this; }
	IrisU24&	operator *=	(const IrisU24& n)	{ IrisU32 lhs = *this; IrisU32 rhs = n; lhs *= rhs; *this = lhs; return *this; }
	IrisU24&	operator %=	(const IrisU24& n)	{ IrisU32 lhs = *this; IrisU32 rhs = n; lhs %= rhs; *this = lhs; return *this; }

	IrisU24		operator +	(void)				const	{ return *this; }
	IrisU24		operator +	(const IrisU24& n)	const	{ IrisU24 ret(*this); ret += n; return ret; }
	//IrisU24		operator -	(void)				const	{ IrisU32 ret = *this; ret = (IrisU32)(-ret); return ret; }
	IrisU24		operator -	(const IrisU24& n)	const	{ IrisU24 ret(*this); ret -= n; return ret; }
	IrisU24		operator /	(const IrisU24& n)	const	{ IrisU24 ret(*this); ret /= n; return ret; }
	IrisU24		operator *	(const IrisU24& n)	const	{ IrisU24 ret(*this); ret *= n; return ret; }
	IrisU24		operator %	(const IrisU24& n)	const	{ IrisU24 ret(*this); ret %= n; return ret; }

	IrisU24		operator ~ (void)	const	{ IrisU24 ret; for( int i=0; i < 3; ++i ) { ret.v[i] = static_cast<IrisU8>(~v[i]); } return ret; }
	bool		operator ! (void)	const	{ for( int i=0; i < 3; ++i ) { if( !v[i] ) return true; } return false; }

	bool		operator == (const IrisU24& n)	const	{ for( int i=0; i < 3; ++i ) { if( v[i] != n.v[i] ) return false; } return true; }
	bool		operator != (const IrisU24& n)	const	{ for( int i=0; i < 3; ++i ) { if( v[i] == n.v[i] ) return false; } return true; }
	bool		operator <  (const IrisU24& n)	const	{ IrisU32 lhs = *this; IrisU32 rhs = n; return lhs < rhs; }
	bool		operator >  (const IrisU24& n)	const	{ IrisU32 lhs = *this; IrisU32 rhs = n; return lhs > rhs; }
	bool		operator <= (const IrisU24& n)	const	{ IrisU32 lhs = *this; IrisU32 rhs = n; return lhs <= rhs; }
	bool		operator >= (const IrisU24& n)	const	{ IrisU32 lhs = *this; IrisU32 rhs = n; return lhs >= rhs; }

} IrisU24;

//! 萔^
template<typename _TN, _TN _FIXED>struct IrisFixedType
{
	typedef _TN value_type;
	typedef IrisFixedType<_TN, _FIXED>	type;

	static const value_type	value = _FIXED;
};

//! ̈^
template<typename _TN>struct IrisTRect
{
	_TN	left, top, right, bottom;
};

//! NH[^jI^
template<typename _TN>struct IrisTQuaternion
{
	_TN	x, y, z, w;

	IrisTQuaternion(void)
		: x(0), y(0), z(0), w(0) {}
	IrisTQuaternion(_TN _x, _TN _y, _TN _z, _TN _w)
		: x(_x), y(_y), z(_z), w(_w) {}
};
//! ʌ^
template<typename _TN>struct IrisTPlane
{
	_TN a, b, c, d;

	IrisTPlane(void)
		: a(0), b(0), c(0), d(0) {}
	IrisTPlane(_TN _a, _TN _b, _TN _c, _TN _d)
		: a(_a), b(_b), c(_c), d(_d) {}
};

//! J[^
template<typename _TN>struct IrisTRGBA
{
private:
	typedef _TN		type;
	typedef _TN		*ptr;
	typedef IrisTRGBA<_TN>	_Myt;
public:
	_TN r, g, b, a;

	IrisTRGBA(void)
		: r(0), g(0), b(0), a(0) {}
	IrisTRGBA(_TN _r, _TN _g, _TN _b, _TN _a)
		: r(_r), g(_g), b(_b), a(_a) {}
	IrisTRGBA(_TN* v)
		: r(v[0]), g(v[1]), b(v[2]), a(v[3]) {}

	operator ptr		(void)			{ return pointer_cast<ptr>(this); }

	bool operator == (const _Myt& t)	{ return (r == t.r) && (g == t.g) && (b == t.b) && (a == t.a); }
	bool operator != (const _Myt& t)	{ return (r != t.r) || (g != t.g) || (b != t.b) || (a != t.a); }
};

/**
 * @brief	ŒTCYzNX
 * @tparam	_TN		= ž^
 * @tparam	_SIZE	= z̗vf
*/
template<typename _TN, IrisU32 _SIZE>
struct IrisFixedArray
{
private:
	typedef IrisFixedArray<_TN, _SIZE>	_Myt;
public:
	_TN	m_Array[_SIZE];
public:
	template<IrisU32 _RSIZE>
	_Myt&	operator = (const IrisFixedArray<_TN, _RSIZE>& r)
	{
		copy(r);
		return *this;
	}

	_TN&		operator [] (int index)			{ return m_Array[index]; }
	const _TN&	operator [] (int index) const	{ return m_Array[index]; }

	operator	_TN*		(void)			{ return m_Array; }
	operator	const _TN*	(void)	const	{ return m_Array; }

	_TN*		ptr(void)		{ return m_Array; }
	const _TN*	ptr(void) const { return m_Array; }

	/**
	 * @brief	vf̎擾
	 * @return	vf
	*/
	IrisU32		size(void)	const		{ return _SIZE; }

	_TN&		at(int index)			{ return m_Array[index]; }
	const _TN&	at(int index)	const	{ return m_Array[index]; }

public:
	template<IrisU32 _RSIZE>
	void		copy(const IrisFixedArray<_TN, _RSIZE>& r)
	{
		IrisU32 _size = size();
		if( _size > r.size() ) _size = r.size;
		for( IrisU32 i=0; i < _size; ++i )
		{
			m_Array[i] = r[i];
		}
	}
};

/**
 * @brief	BȐ^Ul^
 * @note	 = ^
 *			 = U
 *			0	 = B
*/
typedef class IrisVaugeBool
{
public:
	enum TYPE
	{
		VB_TRUE		= -1,
		VB_FALSE	= 1,
		VB_VAUGE	= 0
	};
	int		val;

	IrisVaugeBool(void) : val(0) {}
	IrisVaugeBool(TYPE v) : val(v) {}
	IrisVaugeBool(const IrisVaugeBool& v) : val(v.val) {}

	operator bool	(void)	const	{ return val < 0; }	// ^킵͋U
	operator int	(void)	const	{ return val; }

	bool	is_true(void)	const 	{ return val < 0; }
	bool	is_false(void)	const 	{ return val > 0; }
	bool	is_vauge(void)	const 	{ return val == 0; }

	bool	boolean_test(void)	const { return is_true(); }

	template<typename _TN>
	bool operator == (_TN v)		const 	{ return val == v; }
	bool operator == (bool v)		const	{ return is_true() == v; }
	template<typename _TN>
	bool operator != (_TN v)		const 	{ return val != v; }
	bool operator != (bool v)		const 	{ return is_true() != v; }

	bool operator <  (int v)		const	{ return val <  v; }
	bool operator <= (int v)		const	{ return val <= v; }
	bool operator >  (int v)		const	{ return val >  v; }
	bool operator >= (int v)		const	{ return val >= v; }

	bool operator ! (void)			const	{ return !is_true(); }
} IrisVaugeBool;

// EӔrp
template<typename _TN>
bool operator == (const _TN& lhs, const IrisVaugeBool& rhs)				{ return rhs == lhs; }
STATICINLINE	bool operator == (bool lhs, const IrisVaugeBool& rhs)	{ return rhs == lhs; }
STATICINLINE	bool operator <  (int lhs, const IrisVaugeBool& rhs)	{ return rhs <  lhs; }
STATICINLINE	bool operator <= (int lhs, const IrisVaugeBool& rhs)	{ return rhs <= lhs; }
STATICINLINE	bool operator >  (int lhs, const IrisVaugeBool& rhs)	{ return rhs >  lhs; }
STATICINLINE	bool operator >= (int lhs, const IrisVaugeBool& rhs)	{ return rhs >= lhs; }


class TYPESAFE_FALSE_T;
/**
 * @brief	^LXgi TRUE
*/
const 
class TYPESAFE_TRUE_T
{
	void operator & (void)	const ;						//!< AhXQƂ֎~

public:
	TYPESAFE_TRUE_T(void) {}
	// ? Zqp
	TYPESAFE_TRUE_T(const TYPESAFE_FALSE_T&) {}
public:
	operator BOOL (void) const	{ return TRUE; }
public:
	BOOL	operator == (BOOL rhs) const { return rhs; }
	BOOL	operator != (BOOL rhs) const { return !rhs; }
} TYPESAFE_TRUE;

/**
 * @brief	^LXgi FALSE
*/
const
class TYPESAFE_FALSE_T
{
	void operator & (void)	const ;						//!< AhXQƂ֎~
public:
	TYPESAFE_FALSE_T(void) {}
	// ? Zqp
	TYPESAFE_FALSE_T(const TYPESAFE_TRUE_T&) {}
public:
	operator BOOL (void) const	{ return FALSE; }
public:
	BOOL	operator == (BOOL rhs) const { return !rhs; }
	BOOL	operator != (BOOL rhs) const { return rhs; }
} TYPESAFE_FALSE;

#endif

#endif
