//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_tchar.h
 * @brief		iris_tchar t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_tchar_H_
#define INCG_IRIS_iris_tchar_H_

//======================================================================
// include
#include "iris_inchead.h"
#include <tchar.h>

#if defined(IRIS_MSC)

#  if !defined(_ttof)
#    if defined(UNICODE)
#      define _ttof	_wtof
#    else
#      define _ttof	_atof
#    endif
#  endif

#endif

#endif

#ifndef _tcsequ
#  ifdef UNICODE
#    define _tcsequ(a, b)	(wcscmp(a, b) == 0)
#  else
#    define _tcsequ(a, b)	(strcmp(a, b) == 0)
#  endif
#endif


#ifndef _tcsskipws
#  ifdef UNICODE
#    define _tcsskipws(p_)	wcsskipws(p_)
#  else
#    define _tcsskipws(p_)	strskipws(p_)
#  endif
#endif

STATICINLINE wchar_t*	wcsskipws(wchar_t* p)
{
	wchar_t* tp = p;
	if( tp == nullptr ) return tp;
	while( (*tp == L' ') || (*tp == L'\t') ) ++tp;
	return tp;
}
#if defined(__cplusplus)
STATICINLINE const wchar_t*	wcsskipws(const wchar_t* p)
{
	const wchar_t* tp = p;
	if( tp == nullptr ) return tp;
	while( (*tp == L' ') || (*tp == L'\t') ) ++tp;
	return tp;
}
#endif

STATICINLINE char*	strskipws(char* p)
{
	char* tp = p;
	if( tp == nullptr ) return tp;
	while( (*tp == ' ') || (*tp == '\t') ) ++tp;
	return tp;
}
#if defined(__cplusplus)
STATICINLINE const char*	strskipws(const char* p)
{
	const char* tp = p;
	if( tp == nullptr ) return tp;
	while( (*tp == ' ') || (*tp == '\t') ) ++tp;
	return tp;
}
#endif
