//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_inline.h
 * @brief		CC֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_inline_H_
#define INCG_IRIS_iris_inline_H_

//======================================================================
// include
#include "iris_securelib.h"

#if		defined(_IRIS_SUPPORT_EXT_PLATFORM)
#  include "iris_ext_inline.h"
#else
#  if		defined(IRIS_WIN32)
#    include "platform/windows/win_inline.h"
#  elif		defined(IRIS_APPLE)
#  else
#  endif
#endif

#include "iris_stdc.h"
#include <stdarg.h>

// œKŏȂZeroMemory
#ifndef	SecureZeroMemory
#define SecureZeroMemory	irisSecureZeroMemory
STATICINLINE void*	irisSecureZeroMemory(void* ptr, size_t size)
{
    volatile char *vptr = (volatile char *)ptr;
    while(size--)
	{
        *vptr++ = 0;
    }
	return ptr;
}
#endif

#if !defined(__cplusplus)

#define iris_xor_swap(lhs, rhs)	((lhs ^= rhs), ((rhs ^= lhs), (lhs ^= rhs)))

#else

#define iris_xor_swap(lhs, rhs)	::iris::xor_swap(lhs, rhs)

namespace iris
{

template<typename TN_>
void	xor_swap(TN_& lhs, TN_& rhs)
{
	lhs ^= rhs;
	rhs ^= lhs;
	lhs ^= rhs;
}

template<typename _TN>
void	swap(_TN& lhs, _TN& rhs)
{
	_TN t = lhs;
	lhs = rhs;
	rhs = t;
}
#if	defined(max)
#  undef max
#endif
#if	defined(min)
#  undef min
#endif

template<typename TN>
inline const TN&	max(const TN& a, const TN& b)
{
	return a < b ? b : a;
}
template<typename TN>
inline const TN&	min(const TN& a, const TN& b)
{
	return b < a ? b : a;
}

template<typename TN>
inline const TN&	max(const TN& a, const TN& b, const TN& c)
{
	return a < b ? (b < c ? c : b) : (a < c ? c : a);
}
template<typename TN>
inline const TN&	min(const TN& a, const TN& b, const TN& c)
{
	return b < a ? (b < c ? b : c) : (a < c ? a : c);
}

template<typename TN, class COMP>
inline const TN&	max(const TN& a, const TN& b)
{
	return COMP(a, b) ? b : a;
}
template<typename TN, class COMP>
inline const TN&	min(const TN& a, const TN& b)
{
	return COMP(b, a) ? b : a;
}

template<typename T1>
inline T1			roundup(T1 val, u32 align)
{
	u32 mask = align - 1;
	return static_cast<T1>((val + mask) & ~mask);
}

template<typename T1>
inline T1			rounddown(T1 val, u32 align)
{
	u32 mask = align - 1;
	return static_cast<T1>(val & ~mask);
}

}	// end of namespace iris

#endif


// ȂɂȂϒ֐
#if defined(__cplusplus)
template<typename _TN>
STATICINLINE void NOP_VA_ARGS(_TN fmt, ...) { (void)fmt; return; }
#else
STATICINLINE void NOP_VA_ARGS(char* fmt, ...) { (void)fmt; return; }
#endif


// crt ZLeBΉ
#if !(defined(__STDC_WANT_SECURE_LIB__) && __STDC_WANT_SECURE_LIB__ ) && !defined(IRIS_BORLANDC)

// inline functions
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4820)
#include <string.h>
#include <stdio.h>
#if		IRIS_WCS
#  include <wchar.h>
#endif
IRIS_MSC_PRAGMA_WARNING_END()

STATICINLINE errno_t	strcpy_s(char* dst, size_t size, const char* src)	{ IRIS_UNUSED_VARIABLE(size); strcpy(dst, src); return 0; }
STATICINLINE errno_t	strncpy_s(char* dst, size_t size, const char* src, size_t count)	{ IRIS_UNUSED_VARIABLE(size); strncpy(dst, src, count); return 0; }
STATICINLINE errno_t	strcat_s(char* dst, size_t size, const char* src)	{ IRIS_UNUSED_VARIABLE(size); strcat(dst, src); return 0; }
#if	!IRIS_STDC_VA_ARGS
STATICINLINE int		sprintf_s(char* dst, size_t size, const char* format, ...)
{
	int ret; va_list va;
	IRIS_UNUSED_VARIABLE(size);
	va_start(va, format); ret = vsnprintf(dst, size, format, va); va_end(va); return ret;
}
#endif

STATICINLINE errno_t	freopen_s(FILE** fp, LPCSTR path, LPCSTR mode, FILE* old) { FILE* p = freopen(path,  mode,  old); if( fp != nullptr ) *fp = p; return 0; }


#if		IRIS_WCS

STATICINLINE errno_t	wcscpy_s(wchar_t* dst, size_t size, const wchar_t* src)	{ IRIS_UNUSED_VARIABLE(size); wcscpy(dst, src); return 0; }
STATICINLINE errno_t	wcsncpy_s(wchar_t* dst, size_t size, const wchar_t* src, size_t count)	{ IRIS_UNUSED_VARIABLE(size); wcsncpy(dst, src, count); return 0; }
STATICINLINE errno_t	wcscat_s(wchar_t* dst, size_t size, const wchar_t* src)	{ IRIS_UNUSED_VARIABLE(size); wcscat(dst, src); return 0; }

STATICINLINE errno_t	_wfreopen_s(FILE** fp, LPCWSTR path, LPCWSTR mode, FILE* old) { FILE* p = _wfreopen(path,  mode,  old); if( fp != nullptr ) *fp = p; return 0; }

#if	!IRIS_STDC_VA_ARGS
STATICINLINE int			swprintf_s(LPWSTR dst, size_t size, LPCWSTR format, ...)
{
	int ret; va_list va;
	IRIS_UNUSED_VARIABLE(size);
#if defined(IRIS_MSC)
	va_start(va, format); ret = vsnwprintf(dst, size, format, va); va_end(va); return ret;
#else
	va_start(va, format); ret = vswprintf(dst, size, format, va); va_end(va); return ret;
#endif
}
#endif

#endif

#if defined(__cplusplus)	\
	&& !(defined(__STDC_WANT_LIB_EXT1__) && __STDC_WANT_LIB_EXT1__) && (defined(_CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES) && _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES)

STATICINLINE errno_t	strcpy_s(char* dst, const char* src)				{ strcpy(dst, src); return 0; }
STATICINLINE errno_t	strcat_s(char* dst, const char* src)				{ strcat(dst, src); return 0; }

#if		IRIS_WCS
STATICINLINE errno_t	wcscpy_s(wchar_t* dst, const wchar_t* src)				{ wcscpy(dst, src); return 0; }
STATICINLINE errno_t	wcscat_s(wchar_t* dst, const wchar_t* src)				{ wcscat(dst, src); return 0; }
#endif

#endif

#endif	// end of !(defined(__STDC_WANT_SECURE_LIB__) && __STDC_WANT_SECURE_LIB__ ) && !defined(IRIS_BORLANDC)

#endif
