//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_global.h
 * @brief		irisO[ot@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_global_H_
#define INCG_IRIS_iris_global_H_

//======================================================================
// include
#include "iris_inchead.h"

EXTERN_C_BEGIN

//======================================================================
// struct
//! n[hEFA^[Qbgʎq
typedef enum HDW_TARGET_ID
{
	TARGET_WIN32		= IRIS_FOURCC('W', 'X', '3', '2'),	//!< win32
	TARGET_WINCONSOLE	= IRIS_FOURCC('W', 'X', 'C', 'O'),	//!< win console
	TARGET_WINDLL		= IRIS_FOURCC('W', 'X', 'D', 'L'),	//!< win dll
	TARGET_IPHONE		= IRIS_FOURCC('I', 'P', 'H', 'N'),	//!< iPhone
	TARGET_MAC			= IRIS_FOURCC('M', 'A', 'C', 'X'),	//!< Mac
	TARGET_STM32		= IRIS_FOURCC('S', 'T', '3', '2'),	//!< STM32
	TARGET_UNKNOWN		= IRIS_FOURCC('U', 'N', 'K', 'W')	//!< nuknown0
} HDW_TARGET_ID;
//! Ñp[^
typedef struct tagIRISENTRYINFO
{
	IrisU32		uTarget;	//!< ^[Qbgʎq
#if defined(_WIN32)
#else
	int			argc;
	TCHAR**		argv;
#endif
} IRISENTRYINFO, *LPIRISENTRYINFO;

//======================================================================
// function
// ^[Qbgʎq̎擾
IrisU32			irisGetHardWareTargetID(void);

// ̐擾
int				irisGetArgc(void);
// ̕擾
LPTSTR			irisGetArgvN(int n);
// ̕擾
TCHAR**			irisGetArgv(void);

EXTERN_C_END

#endif
