//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_global.c
 * @brief		iris O[ot@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_iris_global_C_

//======================================================================
// include
#include "iris_global.h"
#include <tchar.h>

//======================================================================
// variable
CONCEAL_SCOPE_BEGIN

static IRISENTRYINFO s_EntryInfo;

CONCEAL_SCOPE_END

//======================================================================
// function
/**********************************************************************//**
 *
 * ^[Qbgʎq̎擾
 *
 -----------------------------------------------------------------------
 * @return ^[Qbgʎq
*//***********************************************************************/
IrisU32 irisGetHardWareTargetID(void)
{
	return s_EntryInfo.uTarget;
}

/**********************************************************************//**
 *
 * ̐擾
 *
 -----------------------------------------------------------------------
 * @return ̐
*//***********************************************************************/
int irisGetArgc(void)
{
#if		defined(_WIN32)
	return __argc;
#else
	return s_EntryInfo.argc;
#endif
}

/**********************************************************************//**
 *
 * ̕擾
 *
 -----------------------------------------------------------------------
 * @param [in]	n = CfbNX
 * @return ̕
*//***********************************************************************/
LPTSTR irisGetArgvN(int n)
{
#if		defined(_WIN32)
	return __targv[n];
#else
	IRIS_UNUSED_VARIABLE(n);
	return s_EntryInfo.argv[n];
#endif
}

/**********************************************************************//**
 *
 * ̕擾
 *
 -----------------------------------------------------------------------
 * @return ̕
*//***********************************************************************/
TCHAR** irisGetArgv(void)
{
#if		defined(_WIN32)
	return __targv;
#else
	return s_EntryInfo.argv;
#endif
}

/**********************************************************************//**
 * @internal
 * @private
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return ^[Qbgʎq
*//***********************************************************************/
EXTERN_C void irisInitialzie(int argc, TCHAR** argv, IrisU32 uId)
{
	s_EntryInfo.uTarget = uId;
#if	!defined(_WIN32)
	s_EntryInfo.argc = argc;
	s_EntryInfo.argv = argv;
#else
	IRIS_UNUSED_VAR(argc);
	IRIS_UNUSED_VAR(argv);
#endif
}
