//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_compiler.h
 * @brief		RpCˑ`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_compiler_H_
#define INCG_IRIS_iris_compiler_H_

//======================================================================
// include
#include "iris_platform.h"
#include "iris_namespace.h"

//======================================================================
// define
#define IRIS_WORKAROUND(x, eq)	(x eq)
//--------------------
// compiler
#if		defined(__INTEL_COMPILER)
#  define IRIS_INTEL		__INTEL_COMPILER
#  define IRIS_INTEL_AT_LEAST(ver)			(__ICC >= ver)
#  define IRIS_INTEL_AT_LESS(ver)			(__ICC < ver)
#endif

#if		defined(_MSC_VER)
#  define IRIS_MSC			_MSC_VER		//!< o[Wl
#  define IRIS_MSC_FULL_VER	_MSC_FULL_VER	//!< to[W
#  define IRIS_MSC_AT_LEAST(ver)			(_MSC_VER >= ver)
#  define IRIS_MSC_AT_LESS(ver)				(_MSC_VER < ver)
#  define IRIS_BOOL_DEC
#  if		defined(_MFC_VER)
#    if			!defined(_IRIS_SUPPORT_MFC)
#      define _IRIS_SUPPORT_MFC
#    endif
#    define IRIS_MFC_VER	_MFC_VER
#    define IRIS_MFC_AT_LEAST(ver)			(_MFC_VER >= ver)
#    define IRIS_MFC_AT_LESS(ver)			(_MFC_VER < ver)
#  endif
#  if		defined(_ATL_VER)
#    define IRIS_ATL_VER	_ATL_VER
#    define IRIS_ATL_AT_LEAST(ver)			(_ATL_VER >= ver)
#    define IRIS_ATL_AT_LESS(ver)			(_ATL_VER < ver)
#  endif
#endif
#if		defined(__MWERKS__)
#  define IRIS_MWERKS		__MWERKS__
#  define IRIS_MWERKS_AT_LEAST(ver)			(__MWERKS__ >= ver)
#  define IRIS_MWERKS_AT_LESS(ver)			(__MWERKS__ < ver)
#  define IRIS_BOOL_DEC
#endif
#if		defined(__GNUC__)
#  define IRIS_GNUC							__GNUC__
#  define IRIS_GNUC_MAJOR					__GNUC__
#  define IRIS_GNUC_MINOR					__GNUC_MINOR__
#  define IRIS_GNUC_AT_LEAST(major, minor)	((__GNUC__ >= major &&  __GNUC_MINOR__ >= minor) || __GNUC__ > major)
#  define IRIS_GNUC_AT_LESS(major, minor)	((__GNUC__ <= major &&  __GNUC_MINOR__ < minor) || __GNUC__ < major)
#  if		defined(_BOOL) && !defined(__EDG__)
#    define IRIS_BOOL_DEC
#  endif
#endif
#if		defined(__CODEGEARC__)
#  define IRIS_CODEGEARC					__CODEGEARC__
#  define IRIS_CODEGEARC_AT_LEAST(ver)		(__CODEGEARC__ >= var)
#  define IRIS_CODEGEARC_AT_LESS(ver)		(__CODEGEARC__ < var)
#endif
#if		defined(__BORLANDC__)
#  define IRIS_BORLANDC						__BORLANDC__
#  define IRIS_BORLANDC_AT_LEAST(ver)		(__BORLANDC__ >= var)
#  define IRIS_BORLANDC_AT_LESS(ver)		(__BORLANDC__ < var)
#  if		defined(__BCPLUSPLUS__) && !defined(__cplusplus)
#    define __cplusplus		199711L	// ISO
#  endif
#endif
#if		defined(__TURBOC__)
#  define IRIS_BORLANDC						__TURBOC__
#  define IRIS_BORLANDC_AT_LEAST(ver)		(__TURBOC__ >= var)
#  define IRIS_BORLANDC_AT_LESS(ver)		(__TURBOC__ < var)
#  if		defined(__TCPLUSPLUS__) && !defined(__cplusplus)
#    define __cplusplus		199711L	// ISO
#  endif
#endif
#if		defined(__IAR_SYSTEMS_ICC__)
#  define IRIS_IAR_SYSTEM					__IAR_SYSTEMS_ICC__
#  define IRIS_IAR_SYSTEM_AT_LEAST(ver)		(__IAR_SYSTEMS_ICC__ >= ver)
#  define IRIS_IAR_SYSTEM_AT_LESS(ver)		(__IAR_SYSTEMS_ICC__ < ver)
#  include <stdio.h>
#endif
#if		defined(__COMO__)
#  define IRIS_COMO							__COMO__
#  define IRIS_COMO_AT_LEAST(ver)			(__COMO_VERSION__ >= ver)
#  define IRIS_COMO_AT_LESS(ver)			(__COMO_VERSION__ < ver)
#  if		defined(_BOOL)
#    define IRIS_BOOL_DEC
#  endif
#endif
#if		defined(__CC_ARM)
#  define IRIS_CC_ARM						__CC_ARM
#  define IRIS_CC_ARM_AT_LEAST(ver)			(__ARMCC_VERSION >= ver)
#  define IRIS_CC_ARM_AT_LESS(ver)			(__ARMCC_VERSION < ver)
#endif
#if		defined(__CINT__)
#  define IRIS_CINT							__CINT__
#endif
#if		defined(__CYGWIN__)
#  define IRIS_CYGWIN						__CYGWIN__
#endif
#if		defined(__EDG__)
#  define IRIS_EDG			__EDG__
#  define IRIS_EDG_AT_LEAST(ver)			(__EDG_VERSION_ >= ver)
#  define IRIS_EDG_AT_LESS(ver)				(__EDG_VERSION_ < ver)
#  if		defined(_BOOL)
//#    define IRIS_BOOL_DEC
#  endif
#endif
#if 1
#else
#	error not supported compiler
#endif


#ifndef IRIS_INTEL_AT_LEAST
#  define IRIS_INTEL_AT_LEAST(a)		0
#  define IRIS_INTEL_AT_LESS(a)			0
#endif
#ifndef IRIS_MSC_AT_LEAST
#  define IRIS_MSC_AT_LEAST(a)			0
#  define IRIS_MSC_AT_LESS(a)			0
#endif
#ifndef IRIS_MFC_AT_LEAST
#  define IRIS_MFC_AT_LEAST(a)			0
#  define IRIS_MFC_AT_LESS(a)			0
#endif
#ifndef IRIS_ATL_AT_LEAST
#  define IRIS_ATL_AT_LEAST(a)			0
#  define IRIS_ATL_AT_LESS(a)			0
#endif
#ifndef IRIS_MWERKS_AT_LEAST
#  define IRIS_MWERKS_AT_LEAST(a)		0
#  define IRIS_MWERKS_AT_LESS(a)		0
#endif
#ifndef IRIS_GNUC_AT_LEAST
#  define IRIS_GNUC_AT_LEAST(a, b)		0
#  define IRIS_GNUC_AT_LESS(a, b)		0
#endif
#ifndef IRIS_CODEGEARC_AT_LEAST
#  define IRIS_CODEGEARC_AT_LEAST(a)	0
#  define IRIS_CODEGEARC_AT_LESS(a)		0
#endif
#ifndef IRIS_BORLANDC_AT_LEAST
#  define IRIS_BORLANDC_AT_LEAST(a)		0
#  define IRIS_BORLANDC_AT_LESS(a)		0
#endif
#ifndef IRIS_IAR_SYSTEM
#  define IRIS_IAR_SYSTEM_AT_LEAST(a)	0
#  define IRIS_IAR_SYSTEM_AT_LESS(a)	0
#endif
#ifndef IRIS_EDG
#  define IRIS_EDG_AT_LEAST(a)			0
#  define IRIS_EDG_AT_LESS(a)			0
#endif
#ifndef IRIS_COMO
#  define IRIS_COMO_AT_LEAST(a)			0
#  define IRIS_COMO_AT_LESS(a)			0
#endif



//--------------------
// C Ki
#define IRIS_STDC_NON	0	//!< W
#define IRIS_STDC_C90	90	//!< C90
#define IRIS_STDC_C95	95	//!< C95
#define IRIS_STDC_C99	99	//!< C99

#ifndef __STDC__
#  if	defined(_POSIX_C_SOURCE)
#    define __STDC__	_POSIX_C_SOURCE
#  endif
#endif

#ifdef __STDC__
#  if		!(defined(__STDC_VERSION__))
#    define IRIS_STDC_VERSION	IRIS_STDC_C90	// C90
#  elif	(__STDC_VERSION__ == 199409L)
#    define IRIS_STDC_VERSION	IRIS_STDC_C95	// C95
#  elif	(__STDC_VERSION__ >= 199901L)
#    define IRIS_STDC_VERSION	IRIS_STDC_C99	// C99
#  else
#    define IRIS_STDC_VERSION	IRIS_STDC_NON	// ?
#  endif
#else
#  if	defined(_ISOC99_SOURCE)
#    define IRIS_STDC_VERSION	IRIS_STDC_C99	// C99
#  elif	defined(IRIS_MWERKS)
#    if		_MSL_C99
#      define	IRIS_STDC_VERSION	IRIS_STDC_C99	// C99
#    endif
#  endif
#endif
#ifndef	IRIS_STDC_VERSION
#  define IRIS_STDC_VERSION		IRIS_STDC_NON	// W
#endif

//--------------------
// C++
#if	!defined(__cplusplus)
#  if	defined(_LANGUAGE_C_PLUS_PLUS)
#    define __cplusplus			199711L	// ISO
#  elif	defined(c_plusplus)
#    define	__cplusplus			c_plusplus
#  endif
#endif

// C++0x
#if	!defined(__cplusplus0x) && defined(__cplusplus)
#  if	__cplusplus > 199711L
#    define __cplusplus0x		__cplusplus
#  elif	defined(IRIS_MSC) && IRIS_MSC_AT_LEAST(1600)	// VC++ 10 ȏ
//#    define __cplusplus0x		__cplusplus
#  endif
#endif

//--------------------
// pragma
#if		defined(IRIS_MSC)
#  define _Pragma(X)			__pragma(X)
#  define __Pragma(X)			_Pragma(X)
#else
#  define __Pragma(X)			_Pragma( #X )
#endif

//--------------------
// restrict
#if		!defined(restrict)
#  if		defined(IRIS_MWERKS)
#    define restrict	_MSL_RESTRICT
#  elif		(IRIS_STDC_VERSION != IRIS_STDC_C99)
#    define restrict
#  endif
#endif

//--------------------
// boolΉ
#if		defined(IRIS_MWERKS)
#  if !__option(bool)
     typedef unsigned char	bool;
#    define true			TRUE
#    define false			FALSE
#  endif
#endif

//--------------------
// WCSΉ
#define IRIS_WCS	1	// ꉞSΉĂƉ

#if		defined(IRIS_MSC)
#  if		defined(_NATIVE_WCHAR_T_DEFINED)
#    define IRIS_WCHAR_NAITIVE
#  endif
#elif	defined(IRIS_MWERKS)
#  if		__option(wchar_type)
#    define IRIS_WCHAR_NAITIVE
#  endif
#else
#  if		defined(__cplusplus)
#    define IRIS_WCHAR_NAITIVE
#  endif
#endif

//--------------------
// __COUNTER__̎L
#if		IRIS_MSC_AT_LEAST(1310) || defined(IRIS_MWERKS) || defined(IRIS_IAR_SYSTEM) || IRIS_GNUC_AT_LEAST(4, 3)
#  define	IRIS_STDC_COUNTER	1
#else
#  define	IRIS_STDC_COUNTER	0
#  define	__COUNTER__			__LINE__	// p
#endif

//--------------------
// __VA_ARGS__̎L
#if		(IRIS_STDC_VERSION == IRIS_STDC_C99)
#  define IRIS_STDC_VA_ARGS		1
#elif	(IRIS_STDC_VERSION == IRIS_STDC_NON)
#  if	IRIS_MSC_AT_LEAST(1400)
#    define IRIS_STDC_VA_ARGS	1
#  endif
#endif

#ifndef IRIS_STDC_VA_ARGS
#  define IRIS_STDC_VA_ARGS	0
#endif

//--------------------
// __func__̎L
#if		(IRIS_STDC_VERSION == IRIS_STDC_C99)
#  define IRIS_STDC_func		1
#else
#  if		IRIS_MSC_AT_LEAST(1310)
#    define IRIS_STDC_func		1
#    define __func__			__FUNCTION__
#  elif		IRIS_BORLANDC_AT_LEAST(0x550)
#    define IRIS_STDC_func		1
#  elif		defined(IRIS_IAR_SYSTEM)
#    define IRIS_STDC_func		1
#  endif
#endif

#ifndef IRIS_STDC_func
#  ifdef __func__
#    define IRIS_STDC_func		1
#  else
#    define IRIS_STDC_func		0
#    define __func__				"__func__"
#  endif
#endif

// __PRETTY_FUNCTION__
#if		defined(__GNUC__) || IRIS_MWERKS_AT_LEAST(0x3000)
#  define IRIS_STDC_PRETTY_FUNCTION		1
#elif	defined(__FUNCSIG__)
#  define IRIS_STDC_PRETTY_FUNCTION		1
#  define __PRETTY_FUNCTION__			__FUNCSIG__
#elif	defined(IRIS_IAR_SYSTEM)
#  define IRIS_STDC_PRETTY_FUNCTION		1
#endif

#ifndef IRIS_STDC_PRETTY_FUNCTION
#  ifdef __PRETTY_FUNCTION__
#    define IRIS_STDC_PRETTY_FUNCTION		1
#  else
#    define IRIS_STDC_PRETTY_FUNCTION		0
#    define __PRETTY_FUNCTION__			__func__
#  endif
#endif
#define __iris_current_func__			__PRETTY_FUNCTION__

//--------------------
// __extension__
#ifndef	__extension__
#  define __extension__
#endif

//--------------------
// inline
#if		(defined(__cplusplus) || (IRIS_STDC_VERSION == IRIS_STDC_C99) || (IRIS_STDC_VERSION == IRIS_STDC_NON) \
	|| (defined(IRIS_MWERKS)))
#else
#  define	__inline
#  define	inline		__inline
#endif

#ifndef INLINE
#  if		defined(__cplusplus) \
	 || (IRIS_STDC_VERSION == IRIS_STDC_C99) || defined(IRIS_GNUC)
#    define INLINE		inline
#  else
#    define INLINE
#  endif
#endif

//--------------------
// forceinline
#ifndef FORCEINLINE
#  if	defined(IRIS_MSC)
#    if		IRIS_MSC_AT_LEAST(1200)
#      define	FORCEINLINE	__forceinline
#    else
#      define	FORCEINLINE	__inline
#    endif
#  else
#    define	FORCEINLINE	__inline
#  endif
#endif

//--------------------
// static inline
#ifndef STATICINLINE
#  define STATICINLINE		static INLINE
#endif

//--------------------
// extern inline
#ifndef EXTERN_INLINE
#  define EXTERN_INLINE		extern INLINE
#endif

//--------------------
// constexpr
#include "c++0x/cpp0x_constexpr.h"

//--------------------
// endian
#if	!defined(__BIG_ENDIAN__) && !defined(__LITTLE_ENDIAN__)
#  if	defined(__BYTE_ORDER)
#    if		__BYTE_ORDER == __LITTLE_ENDIAN
#      define __LITTLE_ENDIAN__
#    elif	__BYTE_ORDER == __BIG_ENDIAN
#      define __BIG_ENDIAN__
#    endif
#  else
#    if		defined(i386) || defined(_WIN32)
#      define	__LITTLE_ENDIAN__
#    elif	defined(__APPLE__)
#      if	__BIG_ENDIAN
#        define	__BIG_ENDIAN__
#      else
#        define	__LITTLE_ENDIAN__
#      endif
#    else
//#      pragma message(force set __LITTLE_ENDIAN__)
#      define	__LITTLE_ENDIAN__
#    endif
#  endif
#endif

//--------------------
// sizeof
#ifndef __sizeof_int
#  define __sizeof_int	sizeof(int)
#endif
#ifndef __sizeof_long
#  define __sizeof_long	sizeof(long)
#endif
#ifndef __sizeof_ptr
#  define __sizeof_ptr	sizeof(void*)
#endif

//--------------------
// template̕ꉻ̉
#if defined(IRIS_MSC) && IRIS_WORKAROUND(IRIS_MSC, <= 1200)
#  define _IRIS_NOT_SUPPORT_TEMPLATE_PARTIAL_SPECIALIZATION
#endif

//--------------------
// c99.h
#ifndef _IRIS_HAS_C99_H
#  if	(IRIS_STDC_VERSION == IRIS_STDC_C99)
#    define _IRIS_HAS_C99_H
#  endif
#  if	defined(IRIS_CYGWIN) || defined(IRIS_GNUC)
#    define _IRIS_HAS_C99_H
#  endif
#endif

//--------------------
// read, write
#ifndef __READ
#  define	__READ	const
#endif
#ifndef __READ_WRITE
#  define __READ_WRITE
#endif
#ifndef __WRITE
#  define __WRITE
#endif
#ifndef __READ_CLEAR
#  define __READ_CLEAR
#endif
#ifndef __READ_CLEAR0
#  define __READ_CLEAR0
#endif
#ifndef __READ_CLEAR1
#  define __READ_CLEAR1
#endif
#ifndef __READ_SET
#  define __READ_SET
#endif
#ifndef __TOGGLE
#  define __TOGGLE
#endif

//--------------------
// __attribute__
#if		!defined(IRIS_GNUC) && !defined(IRIS_MWERKS) && !defined(IRIS_CC_ARM)
#  define __attribute__(attr)		do_attribute__##attr
#  define do_attribute__(attr)		do_attribute__##attr
#  if		defined(IRIS_MSC)
#    define do_attribute__weak		__weak
#  endif
#endif

//--------------------
// weak symbol
#if		defined(IRIS_GNUC)
#  define	IRIS_WEAK
#  define	ATTRIBUTE_WEAK		__attribute__(weak)
#else
#  define	IRIS_WEAK			__weak
#  define	ATTRIBUTE_WEAK
#endif

//--------------------
// paked
#if		defined(IRIS_EDG)
#  if		defined(__arm)
#    define IRIS_PACKED		__packed
#  else
#    define IRIS_PACKED
#  endif
#else
#  define IRIS_PACKED
#endif

//--------------------
// near far
#ifndef NEAR
#  if	defined(IRIS_WIN32)
#    define NEAR	near
#  else
#    define NEAR
#  endif
#endif
#ifndef FAR
#  if	defined(IRIS_WIN32)
#    define FAR		far
#  else
#    define FAR
#  endif
#endif

//--------------------
// s
#if		defined(IRIS_IAR_SYSTEM)
#  define	NON_VOLATILE_MEMORY	__no_init
#else
#  define	NON_VOLATILE_MEMORY
#endif

//--------------------
// __noop
#if		!defined(IRIS_MSC)
#  define	__noop
#endif

//--------------------
// 64bit
#if		defined(_LP64)
#  define __LP64__
#else
#  if	defined(IRIS_WIN32)
#    if		defined(IRIS_WIN64) || defined(_M_X64)
#      if			!defined(__LLP64__)
#        define	__LLP64__
#      endif
#    else
#      if			!defined(__ILP64__)
#        define	__ILP32__
#      endif
#    endif
#  elif	defined(IRIS_BORLANDC)
#    if		(sizeof(void*) == 4)
#      if		(sizeof(int) == 2) && (sizeof(long) == 4)
#        if			!defined(__LP32__)
#          define __LP32__
#        endif
#      elif		(sizeof(int) == 4) && (sizeof(long) == 4)
#        if			!defined(__ILP32__)
#          define __ILP32__
#        endif
#      endif
#    elif	(sizeof(void*) == 8 )
#      if		(sizeof(int) == 4) && (sizeof(long) == 4)
#        if			!defined(__LLP64__)
#          define __LLP64__
#        endif
#      elif		(sizeof(int) == 4) && (sizeof(long) == 8)
#        if			!defined(__LP64__)
#          define __LP64__
#        endif
#      elif	(sizeof(int) == 8) && (sizeof(long) == 8)
#        if		!defined(__ILP64__)
#          define __ILP64__
#        endif
#      endif
#    endif
#  endif
#endif

#if		defined(IRIS_MSC)
#  define IRIS_CHKRETURN	__checkReturn
#else
#  define IRIS_CHKRETURN
#endif

//--------------------
// inline assembler
#ifndef IRIS_INLINE_ASM
#  if	defined(IRIS_MSC)
#    define IRIS_INLINE_ASM(_code)		__asm { _code }
#  elif	defined(IRIS_GNUC)
#    define IRIS_INLINE_ASM(_code)		__asm__ ( #_code )
#  else
#    define IRIS_INLINE_ASM(_code)		(void)0
#  endif
#endif

//--------------------
// thumb R[hǂ
#if	defined(__CC_ARM) || defined(__arm__)
#  if defined(__thumb__) || defined(__thumb)
#    define IRIS_THUMB	1
#  else
#    define IRIS_ARM	1
#  endif
#endif

//--------------------
// ⏕
#if defined(__cplusplus) && !defined(_IRIS_POINTER_CASET_DEFINED)

#define _IRIS_POINTER_CASET_DEFINED	// pointer_cast `ς݂ł邱Ƃ`
template<typename T>
inline T			pointer_cast(void* p)
{
	return static_cast<T>(p);
}
template<typename T>
inline T			pointer_cast(const void* p)
{
	return static_cast<T>(p);
}
#if defined(IRIS_MSC)
template<typename T>
inline T			pointer_cast(PROC p)
{
	return reinterpret_cast<T>(p);
}
#endif

#endif

//--------------------
// C++0x Ή
#if		defined(IRIS_MSC)
#  if IRIS_MSC_AT_LEAST(1600)	// VC 2010 ȍ~
#    define _IRIS_COMPILER_SUPPORT_NULLPTR	1
#  endif
#elif	defined(IRIS_GNUC)
#  if IRIS_GNUC_AT_LEAST(4,6)	// gcc 4.6 ȍ~
#    define _IRIS_COMPILER_SUPPORT_NULLPTR	1
#  endif
#endif


#endif
