//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		scoped_thread.h
 * @brief		scoped_thread t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_scoped_thread_H_
#define INCG_IRIS_scoped_thread_H_

//======================================================================
// include
#include <vector>
#include <process.h>

//======================================================================
// define
/**
 * @brief	XbhXR[vJn
*/
#define THREAD_SCOPE_BEGIN()		do {					\
	struct intr_	{										\
	static UINT WINAPI entry(void* p) {						\
		(void)0

/**
 * @brief	XbhXR[vI
*/
#define THREAD_SCOPE_END()		}											\
	};																		\
	::iris::detail::thread_util::Start(intr_::entry, 0, NULL);				\
	} while(0)

/**
 * @brief	XbhI҂
*/
#define THREAD_SCOPE_WAIT()		::iris::detail::thread_util::Wait()

#define THREAD_SCOPE_PP_TO_STRING(x)	THREAD_SCOPE_PP_TO_STRING_(x)
#define THREAD_SCOPE_PP_TO_STRING_(x)	#x

namespace iris {
namespace detail
{

//======================================================================
// class
class thread_util
{
public:
	typedef unsigned long	u32;

#if defined(_WIN32)
	typedef HANDLE		thread_handle;
#else

#endif

public:
	typedef UINT (WINAPI* LPTHREAD_START_ROUTINE)(void*);

private:
	class thread
	{
	public:
		static thread_handle	Create(LPTHREAD_START_ROUTINE entry, u32 stackSize, LPVOID args)
		{
#if defined(_WIN32)
			UINT addr = 0;
			thread_handle hThread = (thread_handle)::_beginthreadex(NULL, stackSize, entry, args
				, CREATE_SUSPENDED , &addr );
			::ResumeThread(hThread);
			return hThread;
#else
#endif
		}
		static u32 Wait(thread_handle hdle, u32 timeout)
		{
#if defined(_WIN32)
			DWORD dwExitCode = 0;
			::GetExitCodeThread(hdle, &dwExitCode);
			if( dwExitCode == STILL_ACTIVE )	// IĂȂ҂
			{
				return ::WaitForSingleObject(hdle, timeout);
			}
			return dwExitCode;
#else
#endif
		}
	};

	class container
	{
		typedef std::vector<thread_handle>	vector_thread;
		vector_thread	threads;
	public:
		void	push(thread_handle hdle)
		{
			threads.push_back(hdle);
		}
		void	remove(thread_handle hdle)
		{
			for( vector_thread::iterator it=threads.begin(), end=threads.end(); it != end; ++it )
			{
				if( (*it) == hdle )
				{
					threads.erase(it);
					return;
				}
			}
		}

		void	pop_wait(void)
		{
			vector_thread::iterator it = threads.begin();
			if( it == threads.end() ) return;
			HANDLE hdle = *it;
			threads.erase(it);
			thread::Wait(hdle, INFINITE);
		}

	public:
		static	container&	get_instance(void)	{ static container inst; return inst; }
	};

public:


	static void	Start(LPTHREAD_START_ROUTINE entry, u32 stackSize, LPVOID args)
	{
		thread_handle hdle = thread::Create(entry, stackSize, args);
		container::get_instance().push(hdle);
	}
	static void	Wait(void)
	{
		container::get_instance().pop_wait();
	}
};


}	// end of namespace detail
}	// end of namespace iris

#endif
