//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLUTApp.cpp
 * @brief		GLUT AvP[VNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLUTApp_CPP_

//======================================================================
// include
#include "GXGLUTApp.h"
#include "../../../fnd/container/smart_ptr/FndStaticPtr.h"
#include "../GXGL.h"
#include "../../../iris_stdlib.h"
#include "../../../iris_debug.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// variable
namespace
{
	fnd::CStaticPtr<CGLUTApp> s_pApp;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGLUTApp::CGLUTApp(void)
: m_Window(0)
{
	IRIS_ASSERT( s_pApp == nullptr );
	s_pApp = this;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGLUTApp::~CGLUTApp(void)
{
	s_pApp = nullptr;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	argcp		= ̐ϐAhX
 * @param [in]	argv		= zAhX
 * @param [in]	displayMode	= \[h
 * @return	
*//***********************************************************************/
bool CGLUTApp::Initialize(int* argcp, char** argv, u32 displayMode)
{
	gxglutInit(argcp, argv);
	gxglutInitDisplayMode(displayMode);
	atexit(_ExitFunc);
	gxglClearColor(0);
	return OnInit();
}

/**********************************************************************//**
 *
 * EBhE쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	x		= EBhExW
 * @param [in]	y		= EBhEyW
 * @param [in]	w		= EBhE
 * @param [in]	h		= EBhE
 * @param [in]	title	= EBhE^Cg
 * @return 
*//***********************************************************************/
bool CGLUTApp::Create(int x, int y, int w, int h, LPCSTR title)
{
	gxglutInitWindowPosition(x, y);
	gxglutInitWindowSize(w, h);
	m_Window = gxglutCreateWindow(title);
	if( m_Window == 0 ) return false;
	gxglViewport(0, 0, w, h);
	gxglutDisplayFunc(_DisplayFunc);
	gxglutReshapeFunc(_ReshapeFunc);
	gxglutIdleFunc(_IdleFunc);
	return true;
}

/**********************************************************************//**
 *
 * EBhEj
 *
*//***********************************************************************/
void CGLUTApp::Destroy(void)
{
	gxglutDestroyWindow(m_Window);
	m_Window = 0;
}

/**********************************************************************//**
 *
 * s
 *
*//***********************************************************************/
void CGLUTApp::Run(void)
{
	gxglutMainLoop();
}

/**********************************************************************//**
 * @internal
 *
 * `CxgGg
 *
*//***********************************************************************/
void GXGLUTCALLBACK	CGLUTApp::_DisplayFunc(void)
{
	if( s_pApp == nullptr ) return;
	s_pApp->OnDisplay();
}

/**********************************************************************//**
 * @internal
 *
 * `ύXCxgGg
 *
*//***********************************************************************/
void GXGLUTCALLBACK	CGLUTApp::_ReshapeFunc(int width, int height)
{
	if( s_pApp == nullptr ) return;
	s_pApp->OnReshape(width, height);
	gxglViewport(0, 0, width, height);
}

/**********************************************************************//**
 * @internal
 *
 * IDLECxgGg
 *
*//***********************************************************************/
void GXGLUTCALLBACK	CGLUTApp::_IdleFunc(void)
{
	if( s_pApp == nullptr ) return;
	s_pApp->OnIdle();
}

/**********************************************************************//**
 * @internal
 *
 * exitCxgGg
 *
*//***********************************************************************/
void GXGLUTCALLBACK	CGLUTApp::_ExitFunc(void)
{
	if( s_pApp == nullptr ) return;
	s_pApp->OnExit();
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif
