//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLShader.cpp
 * @brief		GLSL VF[_[IuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLShader_CPP_

//======================================================================
// include
#include "GXGLShader.h"

#if		defined(_IRIS_SUPPORT_OPENGL)

#include "../../../fnd/io/FndFile.h"
#include "../../../fnd/memory/FndMemory.h"

//======================================================================
// const
namespace {
	static const int LOG_BUFFER_LENGTH = 1024;	// Oo͗pobt@TCY
}

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGLShader::CGLShader(void)
: m_Shader(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGLShader::~CGLShader(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * IuWFNg̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	Type	= VF[_[^Cv(GL_VERTEX_SHADER or GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER)
 * @return	
*//***********************************************************************/
bool CGLShader::Create(GLenum Type)
{
	if( glCreateShader == nullptr ) return false;
	m_Shader = glCreateShader(Type);
	if( m_Shader == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
*//***********************************************************************/
void CGLShader::Delete(void)
{
	if( m_Shader == 0 ) return;
	glDeleteShader(m_Shader);
	m_Shader = 0;
}

/**********************************************************************//**
 *
 * \[XvO̓ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	pName	= VF[_[\[Xt@C
 * @return	
*//***********************************************************************/
bool CGLShader::Load(LPCSTR pName)
{
	if( m_Shader == 0 ) return false;
	fnd::CFile file;
	if( !file.OpenA(pName, "rb") ) return false;
	u32 size = file.GetSize();
	GLint length = static_cast<GLint>(size);
	void* buf = irisAlloc(size, 0);
	if( buf == nullptr ) return false;

	file.Read(buf, size, 1);

	// VF[_[Ƀ\[Xo^
	glShaderSource(m_Shader, 1
		, const_cast<const GLchar**>(pointer_cast<GLchar**>(&buf)), &length);

	// 
	irisFree(buf);
	return true;
}

/**********************************************************************//**
 *
 * vÕRpC
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CGLShader::Compile(void)
{
	GLint compiled = 0;
	if( m_Shader == 0 ) return false;
	// RpC
	glCompileShader(m_Shader);
	getiv(GL_COMPILE_STATUS, &compiled);
#ifdef _IRIS_DEBUG
	char log[LOG_BUFFER_LENGTH];
	GetInfoLog(log, LOG_BUFFER_LENGTH);
	dprintfA("Shader Info Log\n%s\n", log);
#endif
	if( !compiled )	return false;
	return true;
}

/**********************************************************************//**
 *
 * O̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pString	= o̓obt@
 * @param [in]	nSize	= o̓obt@TCY
 * @return	񂾃TCYipStringnullptrnꍇ́AKvȃTCYj
*//***********************************************************************/
GLsizei CGLShader::GetInfoLog(LPSTR pString, GLsizei nSize) const
{
	GLsizei written = 0;
	if( pString == nullptr )
	{
		getiv(GL_INFO_LOG_LENGTH, &written);
		return written;
	}
	glGetShaderInfoLog(m_Shader, nSize, &written, pString);
	return written;
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif
