//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLTexture.h
 * @brief		gl TextureNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLTexture_H_
#define INCG_IRIS_GXGLTexture_H_

//======================================================================
// include
#include "GXGL.h"
#include "../../iris_object.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
/// gl TextureNX
class CGLTexture : public IIrisObject
{
protected:
	GLuint	m_TextureID;	//!< eNX`ID
	GLsizei	m_Width;		//!< 
	GLsizei	m_Height;		//!< c
public:
	// RXgN^
	CGLTexture(void);
	// fXgN^
	virtual ~CGLTexture(void);
public:

	// 쐬
	virtual bool	Create(void);
	// 
	virtual void	Release(void);

public:
	// ֘At
	void	Bind(void);
	// `
	virtual	void	Draw2D(void);

public:
	/// eNX`ID̎擾
	GLuint	GetTextureID(void)	const	{ return m_TextureID; }

public:
	// C[W̊蓖
	void	Image2D(GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border
				, GLenum format, GLenum type, const GLvoid* pixels);
	// C[W̊蓖
	void	SubImage2D(GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height
				, GLenum format, GLenum type, const GLvoid* pixels);
	// p[^ݒ
	static	void	Parameteri (GLenum pname, GLint param)			{ glTexParameteri (GL_TEXTURE_2D, pname, param); }
	static	void	Parameteriv(GLenum pname, const GLint* params)	{ glTexParameteriv(GL_TEXTURE_2D, pname, params); }
	static	void	Parameterf (GLenum pname, GLfloat param)		{ glTexParameterf (GL_TEXTURE_2D, pname, param); }
	static	void	Parameterfv(GLenum pname, const GLfloat* params){ glTexParameterfv(GL_TEXTURE_2D, pname, params); }
};

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
