//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLFVF.h
 * @brief		gxgl _֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLFVF_H_
#define INCG_IRIS_GXGLFVF_H_

//======================================================================
// include
#include "GXGL.h"
#include "../../iris_object.h"
#include "../../iris_debug.h"

#if	defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// declare

//======================================================================
// class
/**
 * @brief	_tH[}bgNX
 * @tparam _FVF	= _tH[}bg
*/
template<u32 _FVF>
class CGLFVF : public IIrisObject
{
	typedef CGLFVF<_FVF>	_Myt;
protected:
	// texture
	template<u32 fvf, typename TMP>
	struct _fvf_texture
	{
		enum { value = false, size = 0 };
		typedef int	value_type;
	};
	template<typename TMP>
	struct _fvf_texture<GXGL_TEXTURE_BYTE, TMP>
	{
		enum { value = true, size = 1*2 };
		typedef	s8	value_type;
	};
	template<typename TMP>
	struct _fvf_texture<GXGL_TEXTURE_SHORT, TMP>
	{
		enum { value = true, size = 2*2 };
		typedef	s16	value_type;
	};
	template<typename TMP>
	struct _fvf_texture<GXGL_TEXTURE_FLOAT, TMP>
	{
		enum { value = true, size = 4*2 };
		typedef	f32	value_type;
	};

	// color
	template<u32 fvf, typename TMP>
	struct _fvf_color
	{
		enum { value = false, num = 0, size = 0 };
		typedef int	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGB_BYTE, TMP>
	{
		enum { value = true, num = 3, size = 1*num };
		typedef	u8	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGB_SHORT, TMP>
	{
		enum { value = true, num = 3, size = 2*num };
		typedef	u16	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGB_FLOAT, TMP>
	{
		enum { value = true, num = 3, size = 4*num };
		typedef	f32	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGBA_BYTE, TMP>
	{
		enum { value = true, num = 4, size = 1*num };
		typedef	u8	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGBA_SHORT, TMP>
	{
		enum { value = true, num = 4, size = 2*num };
		typedef	u16	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_RGBA_FLOAT, TMP>
	{
		enum { value = true, num = 4, size = 4*num };
		typedef	f32	value_type;
	};
	template<typename TMP>
	struct _fvf_color<GXGL_COLOR_FIXED, TMP>
	{
		enum { value = true, num = 4, size = 1*num };
		typedef	u8	value_type;
	};

	// normal
	template<u32 fvf, typename TMP>
	struct _fvf_normal
	{
		enum { value = false, size = 0 };
		typedef int	value_type;
	};
	template<typename TMP>
	struct _fvf_normal<GXGL_NORMAL_BYTE, TMP>
	{
		enum { value = true, size = 1*3 };
		typedef	s8	value_type;
	};
	template<typename TMP>
	struct _fvf_normal<GXGL_NORMAL_SHORT, TMP>
	{
		enum { value = true, size = 2*3 };
		typedef	s16	value_type;
	};
	template<typename TMP>
	struct _fvf_normal<GXGL_NORMAL_FLOAT, TMP>
	{
		enum { value = true, size = 4*3 };
		typedef	f32	value_type;
	};

	// vertex
	template<u32 fvf, typename TMP>
	struct _fvf_vertex
	{
		enum { value = false, size = 0 };
		typedef int	value_type;
	};
	template<typename TMP>
	struct _fvf_vertex<GXGL_VERTEX_BYTE, TMP>
	{
		enum { value = true, size = 1 };
		typedef	s8	value_type;
	};
	template<typename TMP>
	struct _fvf_vertex<GXGL_VERTEX_SHORT, TMP>
	{
		enum { value = true, size = 2 };
		typedef	s16	value_type;
	};
	template<typename TMP>
	struct _fvf_vertex<GXGL_VERTEX_FLOAT, TMP>
	{
		enum { value = true, size = 4 };
		typedef	f32	value_type;
	};

	// vertex num
	template<u32 fvf, typename TMP>
	struct _fvf_vertex_dimension
	{
		enum { num = 0 };
	};
	template<typename TMP>
	struct _fvf_vertex_dimension<GXGL_VERTEX_XYZ, TMP>
	{
		enum { num = 3 };
	};
	template<typename TMP>
	struct _fvf_vertex_dimension<GXGL_VERTEX_XY, TMP>
	{
		enum { num = 2 };
	};
	template<typename TMP>
	struct _fvf_vertex_dimension<GXGL_VERTEX_X, TMP>
	{
		enum { num = 1 };
	};
	template<typename TMP>
	struct _fvf_vertex_dimension<GXGL_VERTEX_XYZW, TMP>
	{
		enum { num = 4 };
	};

	typedef	_fvf_texture<_FVF & GXGL_TEXTURE_BITS, void>	fvf_texture;
	typedef _fvf_color<_FVF & GXGL_COLOR_BITS, void>		fvf_color;
	typedef	_fvf_normal<_FVF & GXGL_NORMAL_BITS, void>		fvf_normal;
	typedef	_fvf_vertex<_FVF & GXGL_VERTEX_BITS, void>		fvf_vertex;
	typedef _fvf_vertex_dimension<_FVF & GXGL_VERTEX_SIZE_BITS, void>	fvf_vertex_dimension;

public:
	enum
	{
		texture_size	= fvf_texture::size,			//!< texture info size
		color_size		= fvf_color::size,				//!< color info size
		color_num		= fvf_color::num,				//!< color info num
		normal_size		= fvf_normal::size,				//!< normal info size
		vtx_size		= fvf_vertex::size,				//!< vertex info size
		vertex_num		= fvf_vertex_dimension::num,	//!< vertex dimension num

		is_texture	= fvf_texture::value,		//!< has texture
		is_color	= fvf_color::value,			//!< has color
		is_normal	= fvf_normal::value,		//!< has normal
		is_vertex	= fvf_vertex::value,		//!< has vertex
	};
	typedef	typename fvf_texture::value_type	texture_type;	//!< texture value type
	typedef typename fvf_color::value_type		color_type;		//!< color value type
	typedef typename fvf_normal::value_type		normal_type;	//!< normal value type
	typedef typename fvf_vertex::value_type		vertex_type;	//!< vertex value type

public:
	enum
	{
		FVF		= _FVF,	//!< FVF
		SIZE	= texture_size + color_size + normal_size + vtx_size * vertex_num,	//!< TCY
	};
public:
	u8	m_vtx[SIZE];

public:
	texture_type&	u(void)		{ IRIS_ASSERT(texture_size); return *(pointer_cast<texture_type*>(m_vtx)); }			//!< u
	texture_type&	v(void)		{ IRIS_ASSERT(texture_size); return *(pointer_cast<texture_type*>(m_vtx) + 1); }		//!< v

	color_type&		r(void)		{ IRIS_ASSERT(color_num);		return *(pointer_cast<color_type*>(m_vtx + texture_size)); }		//!< r
	color_type&		g(void)		{ IRIS_ASSERT(color_num);		return *(pointer_cast<color_type*>(m_vtx + texture_size) + 1); }	//!< g
	color_type&		b(void)		{ IRIS_ASSERT(color_num);		return *(pointer_cast<color_type*>(m_vtx + texture_size) + 2); }	//!< b
	color_type&		a(void)		{ IRIS_ASSERT(color_num > 3);	return *(pointer_cast<color_type*>(m_vtx + texture_size) + 3); }	//!< a

	normal_type&	nx(void)	{ IRIS_ASSERT(normal_size); return *((normal_type*)(m_vtx + texture_size + color_size)); }		//!< normal x
	normal_type&	ny(void)	{ IRIS_ASSERT(normal_size); return *((normal_type*)(m_vtx + texture_size + color_size) + 1); }	//!< normal y
	normal_type&	nz(void)	{ IRIS_ASSERT(normal_size); return *((normal_type*)(m_vtx + texture_size + color_size) + 2); }	//!< normal z

	vertex_type&	x(void)		{ IRIS_ASSERT(vertex_num > 0); return *(pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size)); }		//!< x
	vertex_type&	y(void)		{ IRIS_ASSERT(vertex_num > 1); return *(pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 1); }	//!< y
	vertex_type&	z(void)		{ IRIS_ASSERT(vertex_num > 2); return *(pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 2); }	//!< z
	vertex_type&	w(void)		{ IRIS_ASSERT(vertex_num > 3); return *(pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 3); }	//!< w

public:
	texture_type*	pu(void)	{ IRIS_ASSERT(texture_size); return (pointer_cast<texture_type*>(m_vtx)); }			//!< u
	texture_type*	pv(void)	{ IRIS_ASSERT(texture_size); return (pointer_cast<texture_type*>(m_vtx) + 1); }		//!< v

	color_type*		pr(void)	{ IRIS_ASSERT(color_size);		return (pointer_cast<color_type*>(m_vtx + texture_size)); }			//!< r
	color_type*		pg(void)	{ IRIS_ASSERT(color_size);		return (pointer_cast<color_type*>(m_vtx + texture_size) + 1); }		//!< g
	color_type*		pb(void)	{ IRIS_ASSERT(color_size);		return (pointer_cast<color_type*>(m_vtx + texture_size) + 2); }		//!< b
	color_type*		pa(void)	{ IRIS_ASSERT(color_size > 3);	return (pointer_cast<color_type*>(m_vtx + texture_size) + 3); }		//!< a

	normal_type*	pnx(void)	{ IRIS_ASSERT(normal_size); return (pointer_cast<normal_type*>(m_vtx + texture_size + color_size)); }		//!< normal x
	normal_type*	pny(void)	{ IRIS_ASSERT(normal_size); return (pointer_cast<normal_type*>(m_vtx + texture_size + color_size) + 1); }	//!< normal y
	normal_type*	pnz(void)	{ IRIS_ASSERT(normal_size); return (pointer_cast<normal_type*>(m_vtx + texture_size + color_size) + 2); }	//!< normal z

	vertex_type*	px(void)	{ IRIS_ASSERT(vertex_num > 0); return (pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size)); }		//!< x
	vertex_type*	py(void)	{ IRIS_ASSERT(vertex_num > 1); return (pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 1); }	//!< y
	vertex_type*	pz(void)	{ IRIS_ASSERT(vertex_num > 2); return (pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 2); }	//!< z
	vertex_type*	pw(void)	{ IRIS_ASSERT(vertex_num > 3); return (pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size) + 3); }	//!< w

public:
	_Myt&	u(texture_type u)	{ u() = u; return *this; }	//!< u
	_Myt&	v(texture_type v)	{ v() = v; return *this; }	//!< v

	_Myt&	r(color_type r)		{ r() = r; return *this; }	//!< r
	_Myt&	g(color_type g)		{ g() = g; return *this; }	//!< g
	_Myt&	b(color_type b)		{ b() = b; return *this; }	//!< b
	_Myt&	a(color_type a)		{ a() = a; return *this; }	//!< a

	_Myt&	nx(normal_type x)	{ nx() = x; return *this; }	//!< normal x
	_Myt&	ny(normal_type y)	{ ny() = y; return *this; }	//!< normal y
	_Myt&	nz(normal_type z)	{ nz() = z; return *this; }	//!< normal z

	_Myt&	x(vertex_type x)	{ x() = x; return *this; }	//!< x
	_Myt&	y(vertex_type y)	{ y() = y; return *this; }	//!< y
	_Myt&	z(vertex_type z)	{ z() = z; return *this; }	//!< z
	_Myt&	w(vertex_type w)	{ w() = w; return *this; }	//!< w

public:
	_Myt&	color(color_type r, color_type g, color_type b, color_type a)
	{
	}
	_Myt&	normal(vertex_type x, vertex_type y, vertex_type z)
	{
		normal_type* vtx = pointer_cast<normal_type*>(m_vtx + texture_size + color_size);
		*vtx++ = x; *vtx++ = y; *vtx = z;
		return *this;
	}
	_Myt&	vertex(vertex_type x, vertex_type y)
	{
		vertex_type* vtx = pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size);
		*vtx++ = x; *vtx = y;
		return *this;
	}
	_Myt&	vertex(vertex_type x, vertex_type y, vertex_type z)
	{
		vertex_type* vtx = pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size);
		*vtx++ = x; *vtx++ = y; *vtx = z;
		return *this;
	}
	_Myt&	vertex(vertex_type x, vertex_type y, vertex_type z, vertex_type w)
	{
		vertex_type* vtx = pointer_cast<vertex_type*>(m_vtx + texture_size + color_size + normal_size);
		*vtx++ = x; *vtx++ = y; *vtx++ = z; *vtx = w;
		return *this;
	}
};


}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
