//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXManager.cpp
 * @brief		FBX SDK Managert@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXManager_CPP_

//======================================================================
// include
#include "FBXManager.h"
#include "../../preprocessor/PPString.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_FBX

//======================================================================
// link
#if		defined(_WIN32)

#if FBXSDK_AT_LEAST(FBXSDK_VER_201201)
#  if	(_IRIS_SUPPORT_FBX == IRIS_DYNAMIC_LIB)
#    define FBX_LIBNAME_BAR			""
#    define FBX_LIBNAME_MODE		""
#  else
#    define FBX_LIBNAME_BAR			"-"
#    define FBX_LIBNAME_MODE		IRIS_LIB_MODE
#  endif

#  pragma comment( lib, "fbxsdk-" \
	IRIS_PP_TOSTRING(FBXSDK_VER_FLOAT) \
	FBX_LIBNAME_BAR		\
	FBX_LIBNAME_MODE	\
	IRIS_LIB_POSTFIX	\
	".lib" )

#else
#  if	(_IRIS_SUPPORT_FBX == IRIS_DYNAMIC_LIB)
#    if		(FBXSDK_VER == FBXSDK_VER_201103)
#      define		FBX_LIBNAME_MODE	"20113"
#      define		FBX_LIBNAME_VC		""
#    else
#      pragma error ("not supported fbx sdk dynamic library.")
#      define		FBX_LIBNAME_MODE	""
#      define		FBX_LIBNAME_VC		""
#    endif
#  else
#    define FBX_LIBNAME_MODE		IRIS_LIB_MODE
#    define FBX_LIBNAME_VC			IRIS_LIB_VCVER
#    define FBX_LIBNAME_AMD64		IRIS_LIB_AMD64
#  endif

#  pragma comment( lib, "fbxsdk_" \
	FBX_LIBNAME_MODE	\
	FBX_LIBNAME_VC		\
	FBX_LIBNAME_AMD64	\
	IRIS_LIB_POSTFIX	\
	".lib" )

#endif

# pragma comment ( lib, "wininet.lib" )
#endif

#if		(FBXSDK_VER == FBXSDK_VER_200901)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 200901 ***")
#elif	(FBXSDK_VER == FBXSDK_VER_200903)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 200903 ***")
#elif	(FBXSDK_VER == FBXSDK_VER_201002)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 201002 ***")
#elif	(FBXSDK_VER == FBXSDK_VER_201102)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 201102 ***")
#elif	(FBXSDK_VER == FBXSDK_VER_201103)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 201103 ***")
#elif	(FBXSDK_VER == FBXSDK_VER_201201)
IRIS_PRAGMA_MESSAGE("*** Build FBXSDK Version 201201 ***")
#else
#endif

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
// CFBXManager
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFBXManager::CFBXManager(void)
: m_pMngr(nullptr)
// TODO : warning C4355:this̍\zOɁAthis|C^ANZXĂ͂ȂȂ
//        AANZXȂ悤ӂΖ͂ȂB
IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4355)
, m_Subject(this)
IRIS_PRAGMA_WARNING_DEFAULT(IRIS_MSC, 4355)
{
#if	defined(_IRIS_DEBUG)
	dbgoutput(IRIS_TEXT("using fbx library %s\n"), IRIS_PP_TOSTRING(FBXSDK_VER));
#endif
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFBXManager::~CFBXManager(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * return	
*//***********************************************************************/
bool CFBXManager::Initialize(void)
{
	Release();
	m_pMngr = KFbxSdkManager::Create();
	if( m_pMngr == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CFBXManager::Release(void)
{
	CFBXObserverSubject::value_ptr ptr = m_Subject.GetObservers();
	while(ptr != nullptr)
	{
		ptr->Release();
		m_Subject.DetachObserver(ptr);
		ptr = m_Subject.GetObservers();
	}
#if	FBXSDK_VER == FBXSDK_VER_201002
	// FBX SDK 2010.2 [NΉ
	IOSREF.FreeIOSettings();
#endif
	if( m_pMngr != nullptr )
	{
		m_pMngr->Destroy();
		m_pMngr = nullptr;
	}
}

/**********************************************************************//**
 *
 * KFbxIOPluginRegistry̎擾
 *
 ----------------------------------------------------------------------
 * @return KFbxIOPluginRegistrỹ|C^
*//***********************************************************************/
KFbxIOPluginRegistry* CFBXManager::GetIOPluginRegistry(void) const
{
	if( m_pMngr == nullptr ) return nullptr;
	return m_pMngr->GetIOPluginRegistry();
}

/**********************************************************************//**
 *
 * o[W̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rMajor		= W[o[W
 * @param [out]	rMinor		= }Ci[o[W
 * @param [out] rRevision	= rW
 * @return 
*//***********************************************************************/
bool CFBXManager::GetFileFormatVersion(int& rMajor, int& rMinor, int& rRevision)
{
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201002)
	KFbxSdkManager::GetFileFormatVersion(rMajor, rMinor, rRevision);
	return true;
#else
	IRIS_UNUSED_VARIABLE(rMajor);
	IRIS_UNUSED_VARIABLE(rMinor);
	IRIS_UNUSED_VARIABLE(rRevision);
	IRIS_WARNING("KFbxSdkManager::GetFileFormatVersion is not supported.");
	return false;
#endif
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "FBXImporter.h"
#include "FBXNode.h"
#include "model/FBXMesh.h"
#include "model/FBXMaterial.h"
#include "FBXScene.h"
#include "../gl/GXGLSystem.h"
#include "../../iris_iostream.h"
#include "../../iris_using.h"

//======================================================================
// declare
static void displayFunc(void);

//======================================================================
// class
class CFBXManagerUnitTest : public iris::unit::CUnitTest<CFBXManagerUnitTest>
{
public:
	CFBXScene	m_scene;
	CFBXMesh	m_mesh;
};

//======================================================================
// test
IRIS_UNITTEST_F(CFBXManagerUnitTest, Func)
{
	CFBXManager fbxman;
	CFBXImporter importer;
	CFBXScene& scene = m_scene;
	if( !fbxman.Initialize() ) return;
	if( !fbxman.Create(&importer, "") ) return;
	if( !fbxman.Create(&scene, "") ) return;

	char path[MAX_PATH];
	std::cout << "fbxt@CpX͂ĂB" << std::endl;
	std::cin >> path;
	importer.Initialize(path);
	int major, minor, revision;
	importer.GetFileVersion(major, minor, revision);

	printf("fbx file version = %d. %d. %d.\n", major, minor, revision);
	importer.Import(&scene);
	CFBXNode node = scene->GetRootNode();
	KFbxMesh* pMesh = static_cast<KFbxMesh*>(node.FindAttribute(KFbxNodeAttribute::eMESH));
	m_mesh.Load(pMesh);

	CFBXMaterial mat = m_mesh.GetMaterial(0);

	{
		COpenGL& gl = COpenGL::GetInstance();
		static const u32 buf_size = 4*1024*1024;	// 4KB
		void* buf = new u8 [buf_size];

		COpenGL::INIT_PARAM param;
		param.x = 100;
		param.y = 100;
		param.width = 640;
		param.height = 480;

		gl.Initialize(&param);
		gl.SetDisplayListBuffer(buf, buf_size);

		gl.ClearColor(0xFFFF2222);

		gxglutSetWindowTitle("FBXManagerUnitTest");

		gxglutDisplayFunc( displayFunc );

		gxglutMainLoop();

		delete [] buf;
	}
}

/**********************************************************************//**
 *
 * displayFunc
 *
*//***********************************************************************/
void displayFunc(void)
{
	CFBXManagerUnitTest* ut = CFBXManagerUnitTest::GetCurrent();
	COpenGL& gl = COpenGL::GetInstance();
	gl.Clear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);

	gl.Start();

	CFBXScene& scene = ut->m_scene;
	scene.Draw();
	{
		//ut->m_mesh.Draw();
	}

	gl.Finish();

	gl.SwapBuffers();
}

#endif

#endif
