//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMemStorage.h
 * @brief		CvMemStorage t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvMemStorage_H_
#define INCG_IRIS_CvMemStorage_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	NX
*/
class CCvMemStorage : public IIrisObject
{
protected:
	CvMemStorage*	m_pMem;	//!< 
public:
	// RXgN^
	CCvMemStorage(void);
	explicit CCvMemStorage(int blk_size);
	// fXgN^
	~CCvMemStorage(void);

public:
	// 쐬
	bool	Create(int blk_size=0);
	// 
	void	Release(void);

public:
	/// Lǂ
	bool	IsValid(void)	const	{ return m_pMem != nullptr; }

public:
	/**
	 * @name operator
	 * @{
	*/
	operator CvMemStorage*			(void)			{ return m_pMem; }
	operator const CvMemStorage*	(void)	const	{ return m_pMem; }
	/**
	 * @}
	*/
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
