//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMatrix.h
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvMatrix_H_
#define INCG_IRIS_CvMatrix_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Matrix NX
*/
class CCvMatrix : public IIrisObject
{
protected:
	::cv::Mat	m_Mat;		//!< data
public:
	// RXgN^
	CCvMatrix(void);
	CCvMatrix(const cv::Mat& mat);
	// fXgN^
	virtual ~CCvMatrix(void);

public:
	/**
	 * @name operator
	 * @{
	*/
	operator ::cv::Mat&			(void)			{ return m_Mat; }
	operator const ::cv::Mat&	(void)	const	{ return m_Mat; }
	operator CvMat				(void)			{ return m_Mat; }
	/**
	 * @}
	*/

public:
			::cv::Mat&	GetMat(void)			{ return m_Mat; }
	const	::cv::Mat&	GetMat(void)	const	{ return m_Mat; }

public:
	// 쐬
	void	Create(int rows, int cols, int type);
	void	Create(int rows, int cols, int type, void* data);
	// 
	void	Release(void);

public:
	// K
	void	Normalize(double a=1.0, double b=0.0, int norm_type=CV_L2, const CvArr* mask=nullptr);
	// 2D ]
	void	Rotate2D(const CvPoint2D32f& center, double angle, double scale);
public:
	// iړ
	void	GetRectSubPix(const cv::Mat& src, const CvPoint2D32f& center);
	// ]ړ
	void	GetQuadrangleSubPix(const cv::Mat& src, const CvMat& matrix);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
