//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMatrix.cpp
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvMatrix_CPP_

//======================================================================
// include
#include "CvMatrix.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvMatrix::CCvMatrix(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvMatrix::CCvMatrix(const cv::Mat& mat)
: m_Mat(mat)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvMatrix::~CCvMatrix(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	rows	= s
 * @param [in]	cols	= 
 * @param [in]	type	= ^Cv
*//***********************************************************************/
void CCvMatrix::Create(int rows, int cols, int type)
{
	Release();
#if 0
	CvMat* mat = cvCreateMat(rows, cols, type);
	m_Mat = mat;
#else
	m_Mat.create(rows, cols, type);
#endif
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	rows	= s
 * @param [in]	cols	= 
 * @param [in]	type	= ^Cv
 * @param [in]	data	= f[^
*//***********************************************************************/
void CCvMatrix::Create(int rows, int cols, int type, void* data)
{
	Release();
	m_Mat = &cvMat(rows, cols, type, data);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvMatrix::Release(void)
{
	m_Mat.release();
}

/**********************************************************************//**
 *
 * K
 *
 -----------------------------------------------------------------------
 * @param [in]	src			= 
 * @param [in]	a			= 
 * @param [in]	b			= 
 * @param [in]	norm_type	= 
 * @param [in]	mask		= 
*//***********************************************************************/
void CCvMatrix::Normalize(double a, double b, int norm_type, const CvArr* mask)
{
	CvMat mat = m_Mat;
	cvNormalize(&mat, &mat, a, b, norm_type, mask);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	center	= Sʒu
 * @param [in]	angle	= ]pidegreej
 * @param [in]	scale	= XP[
*//***********************************************************************/
void CCvMatrix::Rotate2D(const CvPoint2D32f& center, double angle, double scale)
{
	CvMat mat = m_Mat;
	cv2DRotationMatrix(center, angle, scale, &mat);
}

/**********************************************************************//**
 *
 * iړ
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [in]	center	= ړ㒆Sʒu
*//***********************************************************************/
void CCvMatrix::GetRectSubPix(const cv::Mat& src, const CvPoint2D32f& center)
{
	if( m_Mat.empty() ) m_Mat = src.clone();
	CvMat smat = src;
	CvMat dmat = m_Mat;
	cvGetRectSubPix(&smat, &dmat, center);
}

/**********************************************************************//**
 *
 * ]ړ
 *
 -----------------------------------------------------------------------
 * @param [in]	src		= 
 * @param [in]	matrix	= ]}gbNX
*//***********************************************************************/
void CCvMatrix::GetQuadrangleSubPix(const cv::Mat& src, const CvMat& matrix)
{
	if( m_Mat.empty() ) m_Mat = src.clone();
	CvMat smat = src;
	CvMat dmat = m_Mat;
	cvGetQuadrangleSubPix(&smat, &dmat, &matrix);
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
