//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvFile.cpp
 * @brief		CvFile t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvFile_CPP_

//======================================================================
// include
#include "CvFile.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvFile::CCvFile(void)
: m_pStorage(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvFile::~CCvFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@CpX
 * @param [in]	pMem		= [Xg[W
 * @param [in]	flags		= tO
 * @return	
*//***********************************************************************/
bool CCvFile::Open(LPCSTR  lpFileName, CvMemStorage* pMem, int flags)
{
	Close();
	m_pStorage = cvOpenFileStorage(lpFileName, pMem, flags);
	return m_pStorage != nullptr;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvFile::Close(void)
{
	if( m_pStorage != nullptr )
	{
		cvReleaseFileStorage(&m_pStorage);
		m_pStorage = nullptr;
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
