//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvMorphology.cpp
 * @brief		OpenCv Matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvMorphology_CPP_

//======================================================================
// include
#include "CvMorphology.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<int OPERATION_>
CCvMorphology<OPERATION_>::CCvMorphology(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	kernel			= 
 * @param [in]	anchor			= 
 * @param [in]	iterations		= 
 * @param [in]	borderType		= 
 * @param [in]	bordefValue		= 
 *//***********************************************************************/
template<int OPERATION_>
CCvMorphology<OPERATION_>::CCvMorphology(const cv::Mat& src, const CCvConvKernel& element, int iterations
										 , int borderType, const cv::Scalar& bordefValue)
{
	Create(src, element, iterations, borderType, bordefValue);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	element			= 
 * @param [in]	iterations		= 
 *//***********************************************************************/
template<int OPERATION_>
CCvMorphology<OPERATION_>::CCvMorphology(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor, int iterations
										 , int borderType, const cv::Scalar& bordefValue)
{
	Create(src, kernel, anchor, iterations, borderType, bordefValue);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	kernel			= 
 * @param [in]	anchor			= 
 * @param [in]	iterations		= 
 * @param [in]	borderType		= 
 * @param [in]	bordefValue		= 
*//***********************************************************************/
template<int OPERATION_>
void CCvMorphology<OPERATION_>::Create(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor, int iterations
									   , int borderType, const cv::Scalar& bordefValue)
{
	MorphologyEx(src, OPERATION, kernel, anchor, iterations, borderType, bordefValue);
}
template<>
void CCvMorphology<CV_MOP_ERODE>::Create(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor, int iterations
										 , int borderType, const cv::Scalar& bordefValue)
{
	MorphologyErode(src, kernel, anchor, iterations, borderType, bordefValue);
}
template<>
void CCvMorphology<CV_MOP_DILATE>::Create(const cv::Mat& src, const cv::Mat& kernel, const cv::Point& anchor, int iterations
										  , int borderType, const cv::Scalar& bordefValue)
{
	MorphologyDilate(src, kernel, anchor, iterations, borderType, bordefValue);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= 
 * @param [in]	element			= 
 * @param [in]	iterations		= 
 * @param [in]	borderType		= 
 * @param [in]	bordefValue		= 
*//***********************************************************************/
template<int OPERATION_>
void CCvMorphology<OPERATION_>::Create(const cv::Mat& src, const CCvConvKernel& element, int iterations
									   , int borderType, const cv::Scalar& bordefValue)
{
	cv::Mat kernel;
	cv::Point anchor;
	element.Convert(kernel, anchor);
	Create(src, kernel, anchor, iterations, borderType, bordefValue);
}

template class CCvMorphology<CV_MOP_ERODE>;
template class CCvMorphology<CV_MOP_DILATE>;
template class CCvMorphology<CV_MOP_OPEN>;
template class CCvMorphology<CV_MOP_CLOSE>;
template class CCvMorphology<CV_MOP_GRADIENT>;
template class CCvMorphology<CV_MOP_TOPHAT>;
template class CCvMorphology<CV_MOP_BLACKHAT>;

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "CvConvKernel.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvMorphologyUnitTest, Func)
{
	CCvImage image;
	CHAR path[MAX_PATH];
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);

	if( !image.Load(path, CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR) ) return;

	CCvConvKernel element(9, 9, 4, 4, CV_SHAPE_RECT);

	CCvMorphology<CV_MOP_ERODE>		erode(image, element);
	CCvMorphology<CV_MOP_DILATE>	dilate(image, element);
	CCvMorphology<CV_MOP_OPEN>		open(image, element);
	CCvMorphology<CV_MOP_CLOSE>		close(image, element);
	CCvMorphology<CV_MOP_GRADIENT>	gradient(image, element);
	CCvMorphology<CV_MOP_TOPHAT>	tophat(image, element);
	CCvMorphology<CV_MOP_BLACKHAT>	blackhat(image, element);

	struct info_
	{
		CCvImage* image;
		const char* name;
	} info[] = {
		{ &erode, "CV_MOP_ERODE"},
		{ &dilate, "CV_MOP_DILATE"},
		{ &open, "CV_MOP_OPEN"},
		{ &close, "CV_MOP_CLOSE"},
		{ &gradient, "CV_MOP_GRADIENT"},
		{ &tophat, "CV_MOP_TOPHAT"},
		{ &blackhat, "CV_MOP_BLACKHAT"},
	};

	CCvWindow window[elementof(info)];
	for( int i=0; i < elementof(info); ++i )
	{
		window[i].Create(info[i].name);
		window[i].ShowImage(*info[i].image);
	}
	cvWaitKey();
}

#endif

#endif
