//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvFont.h
 * @brief		CvFont t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvFont_H_
#define INCG_IRIS_CvFont_H_

//======================================================================
// include
#include "../image/CvImage.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	tHgNX
*/
class CCvFont : public IIrisObject
{
protected:
	CvFont	m_Font;	//!< tHg
public:
	// RXgN^
	CCvFont(void);
	CCvFont(int font_face, double hscale, double vscale
		, double shear=0, int thickness=1, int line_type=8);
	CCvFont(int font_face, double scale
		, int thickness=1, int line_type=8);
	// fXgN^
	~CCvFont(void);

public:
	// 쐬
	void	Create(int font_face, double hscale, double vscale
		, double shear=0, int thickness=1, int line_type=8);
	void	Create(int font_face, double scale
		, int thickness=1, int line_type=8);

public:
	// eLXgTCY擾
	void	GetTextSize(LPCSTR text, CvSize* text_size, int* baseline) const;

public:
	operator		CvFont& (void)			{ return m_Font; }
	operator const	CvFont& (void)	const	{ return m_Font; }
	operator		CvFont* (void)			{ return &m_Font; }
	operator const	CvFont* (void)	const	{ return &m_Font; }

public:
			CvFont&	GetFont(void)			{ return m_Font; }
	const	CvFont&	GetFont(void)	const	{ return m_Font; }
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
