//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvTrackbar.cpp
 * @brief		OpenCV gbNo[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvTrackbar_CPP_

//======================================================================
// include
#include "CvTrackbar.h"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvTrackbar::CCvTrackbar(void)
: m_Pos(0)
, m_pUser(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvTrackbar::~CCvTrackbar(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszTrackbarName	= gbNo[
 * @param [in]	lpszWindowName		= EBhE
 * @param [in]	count				= l
 * @param [in]	pUser				= [U[f[^
 * @return	
*//***********************************************************************/
bool CCvTrackbar::Create(LPCSTR lpszTrackbarName, LPCSTR lpszWindowName, int count, void* pUser)
{
	Close();
	m_Pos = 0;
	m_pUser = pUser;
	if( !cvCreateTrackbar2(lpszTrackbarName, lpszWindowName, &m_Pos, count
		, _OnCallback, this) ) return false;
	m_TrackbarName = lpszTrackbarName;
	return OnCreate(lpszWindowName);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvTrackbar::Close(void)
{
	Detach();
}

/**********************************************************************//**
 *
 * ʒu̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	pos			= ʒu
*//***********************************************************************/
void CCvTrackbar::SetPos(int pos)
{
	cvSetTrackbarPos(m_TrackbarName.c_str(), GetWindowName(), pos);
}

/**********************************************************************//**
 *
 * R[obN֐
 *
 -----------------------------------------------------------------------
 * @param [in]	pos			= ʒu
 * @param [in]	userdata	= [U[f[^
*//***********************************************************************/
void CCvTrackbar::_OnCallback(int pos, void* userdata)
{
	IRIS_ASSERT( userdata != nullptr );
	CCvTrackbar* trackbar = pointer_cast<CCvTrackbar*>(userdata);
	trackbar->OnCallback(pos, trackbar->m_pUser);
}


}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST)) || defined(_IRIS_SUPPORT_GOOGLETEST)
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvTrackbarUnitTest, Func)
{
	CCvTrackbar trackbar;
	CCvWindow window;

	ASSERT_TRUE( window.Create("CvTrackbarUnitTest") );
	ASSERT_TRUE( trackbar.Create("trackbar", window.GetWindowName(), 200, nullptr) );

	ASSERT_EQ(  0, trackbar.GetPos());
	trackbar.SetPos(100);
	ASSERT_EQ(100, trackbar.GetPos());

#if !defined(_IRIS_SUPPORT_GOOGLETEST) || (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
	cvWaitKey();
#endif
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
