//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvSobel.h
 * @brief		CvSobel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvSobel_H_
#define INCG_IRIS_CvSobel_H_

//======================================================================
// include
#include "../image/CvImage.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Sobel tB^NX
*/
class CCvSobel : public CCvImage
{
public:
	// RXgN^
	CCvSobel(void);
	CCvSobel(const CvArr* src, int xorder, int yorder
		, int aperture_size=3
		, int depth=IPL_DEPTH_8U, int channels=1);
	CCvSobel(const ::cv::Mat& src, int xorder, int yorder
		, int aperture_size=3
		, int depth=IPL_DEPTH_8U, int channels=1);
	// fXgN^
	~CCvSobel(void);

public:
	// o
	void	Detect(const CvArr* src, int xorder, int yorder
		, int aperture_size=3
		, double scale=1.0, double delta=0.0, int borderType=::cv::BORDER_DEFAULT);
	void	Detect(const ::cv::Mat& src, int xorder, int yorder
		, int aperture_size=3
		, double scale=1.0, double delta=0.0, int borderType=::cv::BORDER_DEFAULT);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
