//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvSobel.cpp
 * @brief		CvSobel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvSobel_CPP_

//======================================================================
// include
#include "CvSobel.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvSobel::CCvSobel(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	xorder			= x Ȃ 1
 * @param [in]	yorder			= y Ȃ 1
 * @param [in]	aperture_size	= 
*//***********************************************************************/
CCvSobel::CCvSobel(const CvArr* src, int xorder, int yorder
				   , int aperture_size
				   , int depth, int channels)
{
	Create(cvGetSize(src), depth, channels);
	Detect(src, xorder, yorder, aperture_size);
}
CCvSobel::CCvSobel(const cv::Mat& src, int xorder, int yorder
				   , int aperture_size
				   , int depth, int channels)
{
	CvMat mat = src;
	Create(cvGetSize(&mat), depth, channels);
	Detect(src, xorder, yorder, aperture_size);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvSobel::~CCvSobel(void)
{
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	xorder			= x Ȃ 1
 * @param [in]	yorder			= y Ȃ 1
 * @param [in]	aperture_size	= 
 * @param [in]	scale			= XP[
 * @param [in]	delta			= 
 * @param [in]	borderType		= 
*//***********************************************************************/
void CCvSobel::Detect(const CvArr* src, int xorder, int yorder
					  , int aperture_size, double scale, double delta, int borderType)
{
	cv::Mat mat = cv::cvarrToMat(src);
	Detect(mat, xorder, yorder, aperture_size, scale, delta, borderType);
}
/// @ref Detect
void CCvSobel::Detect(const cv::Mat& src, int xorder, int yorder
					  , int aperture_size, double scale, double delta, int borderType)
{
	try
	{
		cv::Sobel(src, m_Mat, m_Mat.depth(), xorder, yorder, aperture_size, scale, delta, borderType);
	}
	catch (...)
	{
		CCvImage gray;
		CCvImage temp;
		gray.TranslateColor(src, CV_BGR2GRAY, 1);
		temp.Create(gray.GetSize(), IPL_DEPTH_16S, 1);
		cv::Sobel(gray, temp, temp.GetMat().depth(), xorder, yorder, aperture_size, scale, delta, borderType);

		Convert(temp);
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../memory/CvMemStorage.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvSobelUnitTest, Func)
{
	CCvImage image;
	CCvWindow window;
	CHAR path[MAX_PATH];
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);

	if( !image.Load(path) ) return;

	CCvSobel sobel(image, 1, 0);

	window.Create("Show Image");
	window.ShowImage(sobel);
	cvWaitKey();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
