//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvHaar.h
 * @brief		Haar-Like  t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CvHaar_H_
#define INCG_IRIS_CvHaar_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "../cv_inchead.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**
 * @ingroup	OpenCV
 * @brief	Haar-Like oNX
*/
class CCvHaar : public IIrisObject
{
protected:
	CvHaarClassifierCascade*	m_pCascade;	//!< JXP[h
public:
	// RXgN^
	CCvHaar(void);
	// fXgN^
	~CCvHaar(void);

public:
	// õ[h
	bool	Load(LPCSTR lpszFileName);

public:
	// o
	CvSeq*	Detect(const CvArr* image, CvMemStorage* storage
					   , double scale_factor=1.1f, int min_neighbors=3, int flags=0
					   , CvSize min_size=cvSize(0, 0), CvSize max_size=cvSize(0, 0));
	CvSeq*	Detect(const cv::Mat& image, CvMemStorage* storage
					   , double scale_factor=1.1f, int min_neighbors=3, int flags=0
					   , CvSize min_size=cvSize(0, 0), CvSize max_size=cvSize(0, 0));

public:
	// 
	void	Release(void);
};

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
