//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvCanny.cpp
 * @brief		CvCanny t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvCanny_CPP_

//======================================================================
// include
#include "CvCanny.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvCanny::CCvCanny(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	aperture_size	= 
*//***********************************************************************/
CCvCanny::CCvCanny(const CvArr* src, double threshold1, double threshold2
				   , int aperture_size
				   , int depth, int channels)
{
	Create(cvGetSize(src), depth, channels);
	Detect(src, threshold1, threshold2, aperture_size);
}
CCvCanny::CCvCanny(const cv::Mat& src, double threshold1, double threshold2
				   , int aperture_size
				   , int depth, int channels)
{
	CvMat mat = src;
	Create(cvGetSize(&mat), depth, channels);
	Detect(src, threshold1, threshold2, aperture_size);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvCanny::~CCvCanny(void)
{
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	src				= C[W
 * @param [in]	aperture_size	= 
*//***********************************************************************/
void CCvCanny::Detect(const CvArr* src, double threshold1, double threshold2, int aperture_size)
{
	cv::Mat mat = cv::cvarrToMat(src);
	Detect(mat, threshold1, threshold2, aperture_size);
}
/// @ref Detect
void CCvCanny::Detect(const cv::Mat& src, double threshold1, double threshold2,  int aperture_size)
{
	try
	{
		cv::Canny(src, m_Mat, threshold1, threshold2, aperture_size);
	}
	catch (...)
	{
		CCvImage gray;
		gray.TranslateColor(src, CV_BGR2GRAY, 1);
		cv::Canny(gray, m_Mat, threshold1, threshold2, aperture_size);
	}
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../memory/CvMemStorage.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvCannyUnitTest, Func)
{
	CCvImage image;
	CCvWindow window;
	CHAR path[MAX_PATH];
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin.getline(path, MAX_PATH);

	if( !image.Load(path) ) return;

	CCvCanny canny(image, 50.0, 200.0);

	window.Create("Show Image");
	window.ShowImage(canny);
	cvWaitKey();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
