//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cv_inchead.h
 * @brief		OpenCV CN[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_cv_inchead_H_
#define INCG_IRIS_cv_inchead_H_

#ifdef _IRIS_SUPPORT_OPENCV

#if _IRIS_SUPPORT_OPENCV
#else
#  undef  _IRIS_SUPPORT_OPENCV
#  define _IRIS_SUPPORT_OPENCV	 IRIS_DYNAMIC_LIB
#endif

/**
 * @defgroup	OpenCV
*/

//======================================================================
// include
#include "../../iris_inchead.h"

IRIS_MSC_PRAGMA_WARNING_BEGIN()
#if	defined(IRIS_WIN32) && !defined(_CRT_SECURE_NO_WARNINGS)
IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4819)
IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4996)
#endif
IRIS_MSC_PRAGMA_WARNING_DISABLE(4365)	// signed/unsigned v܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4668)

#include <opencv/cv.h>
#include "cv_types.h"

IRIS_MSC_PRAGMA_WARNING_END()

//======================================================================
// define
#define CV_NONEDOT_VERSION	CVAUX_STR(CV_MAJOR_VERSION) ## CVAUX_STR(CV_MINOR_VERSION) ## CVAUX_STR(CV_SUBMINOR_VERSION)

//======================================================================
// link
#if 1

#if	defined(IRIS_MSC)
#  if		(_IRIS_SUPPORT_OPENCV == IRIS_DYNAMIC_LIB)
#    define	CV_LIBNAME_TYPE	""
#    define CV_LIBNAME_MODE	""
#    define CV_LIBNAME_VC	""
#  else
#    pragma comment( lib, "comctl32.lib" )
#    pragma comment( lib, "vfw32.lib" )
#    define	CV_LIBNAME_TYPE		"_static_"
#    define CV_LIBNAME_MODE		IRIS_LIB_MODE
#    define CV_LIBNAME_VC		IRIS_LIB_VCVER
#    pragma comment( lib, "libjasper" CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib" )
#    pragma comment( lib, "libjpeg" CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib" )
#    pragma comment( lib, "libtiff" CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib" )
#    pragma comment( lib, "libpng" CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib" )
#    pragma comment( lib, "opencv_lapack" CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib" )
#  endif
#  define OPENCV_LIBNAME(name)	"opencv_" name CV_NONEDOT_VERSION CV_LIBNAME_TYPE CV_LIBNAME_MODE CV_LIBNAME_VC IRIS_LIB_POSTFIX ".lib"
#  pragma comment( lib, OPENCV_LIBNAME("core") )
#  pragma comment( lib, OPENCV_LIBNAME("highgui") )
#  pragma comment( lib, OPENCV_LIBNAME("imgproc") )
#  pragma comment( lib, OPENCV_LIBNAME("objdetect") )
#  undef OPENCV_LIBNAME
#  undef CV_LIBNAME_TYPE
#  undef CV_LIBNAME_MODE
#  undef CV_LIBNAME_VC
#endif

#else

#  define OPENCV_LIBNAME(name)	"opencv_" name CV_NONEDOT_VERSION IRIS_LIB_POSTFIX ".lib"
#  pragma comment( lib, OPENCV_LIBNAME("core") )
#  pragma comment( lib, OPENCV_LIBNAME("highgui") )
#  pragma comment( lib, OPENCV_LIBNAME("imgproc") )
#  pragma comment( lib, OPENCV_LIBNAME("objdetect") )
#  undef OPENCV_LIBNAME

#endif

#endif

#endif
