//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvSystem.cpp
 * @brief		OpenCV System t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvSystem_CPP_

//======================================================================
// include
#include "CvSystem.h"

#ifdef _IRIS_SUPPORT_OPENCV
#include <opencv/highgui.h>

namespace iris {
namespace gx {
namespace ocv
{

//======================================================================
// function
namespace
{

/**********************************************************************//**
 * @private
 * @internal
 *
 * 
 *
*//***********************************************************************/
int _cvInitialize(int argc, char** argv)
{
	cvInitSystem(argc, argv);
	return 0;
}

}

//======================================================================
// class

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	argc	= ̐
 * @param [in]	argv	= 
*//***********************************************************************/
void CCvSystem::Initialize(int argc, char** argv)
{
	static int init = _cvInitialize(argc, argv);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvSystem::Initialize(void)
{
#if	defined(IRIS_WIN32) && !defined(UNICODE)
	Initialize(::__argc, ::__argv);
#else
	Initialize(0, nullptr);
#endif
}

}	// end of namespace ocv
}	// end of namespace gx
}	// end of namespace iris

#endif
