//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgProfile.cpp
 * @brief		Cg SDK vt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CgProfile_CPP_

//======================================================================
// include
#include "CgProfile.h"

#ifdef _IRIS_SUPPORT_CG
#include "../../iris_debug.h"

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCgProfile::CCgProfile(void)
: m_Profile(CG_PROFILE_UNKNOWN)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCgProfile::~CCgProfile(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pProfileString	= vt@C
 * @return	
*//***********************************************************************/
bool CCgProfile::Create(LPCSTR pProfileString)
{
	m_Profile = cgGetProfile(pProfileString);
	if( m_Profile == CG_PROFILE_UNKNOWN ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	index	= T|[gvt@CCfbNX
 * @return	
*//***********************************************************************/
bool CCgProfile::Create(int index)
{
	m_Profile = cgGetSupportedProfile(index);
	if( m_Profile == CG_PROFILE_UNKNOWN ) return false;
	return true;
}

/**********************************************************************//**
 *
 * vpeB̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	query	= NG
 * @return	^Ul
*//***********************************************************************/
CGbool CCgProfile::GetProperty(CGenum query) const
{
	return cgGetProfileProperty(m_Profile, query);
}

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CGXCgProfileUnitTest, Func)
{
	int num = cg::CCgProfile::GetSupportedNum();
	cg::CCgProfile profile;

	for( int i=0; i < num; ++i )
	{
		profile.Create(i);
		printf("Profile %d : %s (%d)\n", i, profile.GetString()
			, profile.GetProfile() );
		IRIS_ASSERT( profile.GetProfile() == cgGetProfile(profile.GetString()) );

		dprintf_bool(IRIS_TEXT("IS_OPENGL_PROFILE     "), profile.GetProperty(CG_IS_OPENGL_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_DIRECT3D_PROFILE   "), profile.GetProperty(CG_IS_DIRECT3D_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_DIRECT3D_8_PROFILE "), profile.GetProperty(CG_IS_DIRECT3D_8_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_DIRECT3D_9_PROFILE "), profile.GetProperty(CG_IS_DIRECT3D_9_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_DIRECT3D_10_PROFILE"), profile.GetProperty(CG_IS_DIRECT3D_10_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_VERTEX_PROFILE     "), profile.GetProperty(CG_IS_VERTEX_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_FRAGMENT_PROFILE   "), profile.GetProperty(CG_IS_FRAGMENT_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_GEOMETRY_PROFILE   "), profile.GetProperty(CG_IS_GEOMETRY_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_TRANSLATION_PROFILE"), profile.GetProperty(CG_IS_TRANSLATION_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_HLSL_PROFILE       "), profile.GetProperty(CG_IS_HLSL_PROFILE));
		dprintf_bool(IRIS_TEXT("IS_GLSL_PROFILE       "), profile.GetProperty(CG_IS_GLSL_PROFILE));
	}
}

#endif

#endif
