//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgContext.h
 * @brief		Cg SDK ReLXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_CgContext_H_
#define INCG_IRIS_CgContext_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_CG
#include "cg_inchead.h"
#include "../../iris_object.h"

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**
 * @ingroup	Cg
 * @brief	Cg ReLXgNX
*/
class CCgContex : private INonCopyable<>
{
private:
	CGcontext	m_Context;	//!< ReLXg
public:
	// RXgN^
	CCgContex(void);
	// fXgN^
	~CCgContex(void);
public:
	// 쐬
	bool		Create(void);
	// 폜
	void		Delete(void);
public:
	// ReLXg̎擾
			CGcontext	GetContext(void)			{ return m_Context; }
	const	CGcontext	GetContext(void)	const	{ return m_Context; }
};

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
