//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CgContext.cpp
 * @brief		Cg SDK ReLXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CgContext_CPP_

//======================================================================
// include
#include "CgContext.h"

#ifdef _IRIS_SUPPORT_CG
#include "../../iris_debug.h"

//======================================================================
// link
#if		defined(_WIN32)
#pragma comment( lib, "cg.lib" )
#endif

namespace iris {
namespace gx {
namespace cg
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCgContex::CCgContex(void)
: m_Context(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCgContex::~CCgContex(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CCgContex::Create(void)
{
	IRIS_ASSERT( m_Context == nullptr );
	m_Context = cgCreateContext();
	if( m_Context == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 폜
 *
*//***********************************************************************/
void CCgContex::Delete(void)
{
	cgDestroyContext(m_Context);
	m_Context = nullptr;
}

}	// end of namespace cg
}	// end of namespace gx
}	// end of namespace iris

#endif
