//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSequence.h
 * @brief		V[PXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSequence_H_
#define INCG_IRIS_FndSequence_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_xf.h"

//======================================================================
// define
// majoro[W
#define	FND_SEQUENCE_VERSION	0x01

namespace iris {
namespace fnd
{

//======================================================================
// enum
/// o[W
typedef enum
{
	SEQ_MAJOR_ID_U		= IRIS_FOURCC('U', 'F', 'S', 'Q'),	//!< 1V[PXt@CID
	SEQ_MAJOR_ID_M		= IRIS_FOURCC('M', 'F', 'S', 'Q'),	//!< nV[PXt@CID
#ifdef _IRIS_SUPPORT_MULTI_SEQUENCE_FILE
	SEQ_MAJOR_ID		= SEQ_MAJOR_ID_M,	//!< major id
#else
	SEQ_MAJOR_ID		= SEQ_MAJOR_ID_U,	//!< major id
#endif
	SEQ_MAJOR_VERSION	= FND_SEQUENCE_VERSION
} SEQ_MAJORINFO;
/// V[PXL[^Cv
typedef enum
{
	eSEQKEY_TYPE_NULL	= 0,	//!< 
	eSEQKEY_TYPE_ON,			//!< L
	eSEQKEY_TYPE_OFF			//!< (f[^̍쐬pAŏIf[^ɂ͊܂܂Ȃ)
} SEQKEY_TYPE;

//======================================================================
// struct
//! V[PXL[
typedef struct tagSEQKEY
{
	s32		type;	//!< L[^Cv
	xf32	time;	//!< L[̊Jn
	u32		offset;	//!< L[f[^ւLPSEQDATÃItZbg
	void*	pData;	//!< L[f[^
} SEQKEY, *LPSEQKEY;
typedef const SEQKEY	*LPCSEQKEY;

//! V[PXf[^
typedef struct tagSEQDATA
{
	u32			option;			//!< IvV
	xf32		total_time;		//!< V[PX̍v
	u32			user_offset;	//!< [U[f[^ւLPSEQDATÃItZbg
	void*		pUser;			//!< [U[f[^

	s32			key_num;		//!< L[̐
	u32			key_offset;		//!< L[zւLPSEQDATÃItZbg
	LPSEQKEY	pKeys;			//!< L[z
	u32			reserve;		//!< \
} SEQDATA, *LPSEQDATA;

//! V[PXf[^wb_
typedef struct tagSEQHEAD
{
	u32			major_id;	//!< FndSequence̎ʎq
	u32			minor_id;	//!< e̎ʎq
	u16			major_ver;	//!< FndSequencẽo[W
	u16			minor_ver;	//!< ẽo[W
	u32			reserve1;	//!< \

#ifdef _IRIS_SUPPORT_MULTI_SEQUENCE_FILE
	s32			seq_num;		//!< V[PX
	u32			seq_offset;		//!< V[PXzւ̃ItZbg
	s32			reserve2[2];	//!< \
#endif
} SEQHEAD, *LPSEQHEAD;

//======================================================================
// class
/// V[PXf[^NX
class CSequenceData : public IIrisObject
{
protected:
	LPSEQDATA	m_pSeqData;	//!< V[PXf[^
public:
	// RXgN^
	CSequenceData(void);
	// fXgN^
	virtual ~CSequenceData(void)	{}

public:
	// f[^̃[h
	virtual		bool	Load(LPSEQDATA pData);
	// t@Cobt@烍[h
	virtual		bool	LoadFile(void* buf, s32 idx=0);
	// f[^̔j
	virtual		void	Unload(void)	{}

public:
	/// L[z̎擾
	LPSEQKEY	GetKeys(void)			{ return  m_pSeqData != nullptr ? m_pSeqData->pKeys : nullptr; }
	LPCSEQKEY	GetKeys(void) const		{ return  m_pSeqData != nullptr ? m_pSeqData->pKeys : nullptr; }

	/// L[̑擾
	s32			GetKeyNum(void)	const	{ return m_pSeqData != nullptr ? m_pSeqData->key_num : 0; }
	/// L[̑擾
	s32			GetKeyNum(s32 type)	const
	{
		if( m_pSeqData == nullptr ) return 0;
		s32 cnt=0;
		for( s32 i=0, n=m_pSeqData->key_num; i < n; ++i )
			if( m_pSeqData->pKeys[i].type == type ) ++cnt;
		return cnt;
	}

	/// L[̌
	s32			FindKey(s32 type)	{ return FindKey(type, -1); }
	/// L[̌
	s32			FindKey(s32 type, s32 pos)
	{
		if( m_pSeqData == nullptr ) return -1;
		for( s32 i=pos+1, n=m_pSeqData->key_num; i < n; ++i )
			if( m_pSeqData->pKeys[i].type == type ) return i;
		return -1;
	}

public:
	/// minor id̎擾
	virtual u32 GetMinorID(void)		const	{ return 0; }
	/// minor version̎擾
	virtual u16	GetMinorVersion(void)	const	{ return 0x00; }
};

/**
 * @brief	V[PXC^[tFCXNX
*/
class ISequence : public IIrisObject
{
	typedef	CSequenceData	data;
	typedef CSequenceData	*data_ptr;
	typedef CSequenceData	&data_ref;
protected:
	data_ptr	m_pData;		//!< ĐV[PX
	xf32		m_CurrTime;		//!< ݂̎
	xf32		m_Speed;		//!< ĐXs[h
public:
	// RXgN^
	ISequence(void);
	// fXgN^
	virtual ~ISequence(void)	{}

public:
	// XV
	virtual void	Update(void);
	// Ԃ̍XV
	virtual	void	Step(void)						{ m_CurrTime += m_Speed; }
	// ݂̃L[ɑ΂Ă̍XV
	virtual	void	Proc(const SEQKEY& key)			= 0;

	// V[PXf[^̐ݒ
	virtual	void	SetSeqData(data_ptr seq_data)	{ m_pData = seq_data; }

protected:
	// XV
	virtual	void	update(xf32 prev_time, xf32 new_time);
public:
	/// ݂̎Ԃ擾
	virtual xf32	GetTime(void)	const		{ return m_CurrTime; }
	/// ݂̎Ԃݒ
	virtual void	SetTime(xf32 time)			{ m_CurrTime = time; }
	/// ĐXs[h̎擾
	virtual xf32	GetSpeed(void)	const		{ return m_Speed; }
	/// ĐXs[h̐ݒ
	virtual void	SetSpeed(xf32 speed)		{ m_Speed = speed; }

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
