//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRingBuffer.h
 * @brief		obt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRingBuffer_H_
#define INCG_IRIS_FndRingBuffer_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	obt@NX
 * @note	OŃobt@ȂƁI
*/
class CRingBuffer : private INonCopyable<CRingBuffer>
{
public:
	typedef enum
	{
		STATUS_OVERFLOW	= 0x00000001	//!< I[o[t[
	} STATUS;
	typedef enum
	{
		SIGNATURE	= IRIS_FOURCC('I', 'R', 'B', 'H')	//!< ʎq
	} TYPES;
public:
	typedef struct HEADER
	{
		u32		signature;	//!< ʎq
		u32		status;		//!< 
		u8*		start;		//!< Oobt@̐擪
		u8*		end;		//!< Oobt@̏I[
		u8*		buf;		//!< obt@̐擪AhX
		u32		size;		//!< Oobt@TCY
	} HEADER, *LPHEADER;
protected:
	LPHEADER	m_pBuffer;

public:
	// RXgN^
	CRingBuffer(void);
	CRingBuffer(void* lpBuffer);
	// fXgN^
	~CRingBuffer(void);

public:
	// 
	void	Init(void* lpBuffer, u32 uSize);
	// o^
	bool	Bind(void* lpBuffer);

	// ǂݍ
	bool	Read(void* lpBuffer, u32 uSize, u32* lpRead);
	// 
	bool	Write(const void* lpBuffer, u32 uSize);
	bool	WriteEx(const void* lpBuffer, u32 offset, u32 uSize, u32 totalSize);

public:
	// Lȃf[^ێĂ邩ǂ
	bool	IsValid(void)	const	{ return (m_pBuffer != nullptr); }
	// ǂݍ݉\obt@TCY̎擾
	u32		GetReadableSize(void);
	// ǂݍ݉\ȂׂẴobt@TCY̎擾
	u32		GetTotalReadableSize(void);
	// ݉\obt@TCY̎擾
	u32		GetWritableSize(void);
	/// obt@TCY̎擾
	u32		GetSize(void)	const	{ return m_pBuffer->size; }

	/// Ԃ̎擾
	u32		GetStatus(void)	const	{ return m_pBuffer->status; }
	/// Ԃ̃NA
	void	ClearStatus(void)		{ m_pBuffer->status = 0; }

protected:
	/// obt@̏I[AhX̎擾
	u8*		GetEnd(void)			{ return m_pBuffer->buf + m_pBuffer->size; }

private:
	// AhX̃CNg
	u8*		_IncAddr(u8* ptr, u32 inc);
	// AhX̃fNg
	u8*		_DecAddr(u8* ptr, u32 dec);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
