//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDPI.h
 * @brief		𑜓x֘At@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndDPI_H_
#define INCG_IRIS_FndDPI_H_

//======================================================================
// include
#include "../container/FndSingleton.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! 𑜓x擾NXC^[tFCX
class IDPI	: public IIrisObject
{
public:
	/// RXgN^
	IDPI(void) {}
	/// fXgN^
	virtual ~IDPI(void) {}
public:
	/// 𑜓x̎擾ij
	virtual s32	GetHDPI(void)	const	= 0;
	/// 𑜓x̎擾icj
	virtual s32	GetVDPI(void)	const	= 0;
};

//! 𑜓x擾NX
class CDPI : public CSingleton<CDPI>, public IDPI
{
public:
	static s32	GetHDPI(void)	{ IDPI* pdpi = CDPI::GetInstancePtr(); return pdpi == nullptr ? 0 : pdpi->GetHDPI(); }
	static s32	GetVDPI(void)	{ IDPI* pdpi = CDPI::GetInstancePtr(); return pdpi == nullptr ? 0 : pdpi->GetVDPI(); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
