//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndConvertEndian.h
 * @brief		GfBAϊΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndConvertEndian_H_
#define INCG_IRIS_FndConvertEndian_H_

//======================================================================
// include
#include "../types/FndEndian.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	GfBA]NX
 * @note	Release[hł́Aendian16,32,64ϐȊȌlsȂ
 *			ɓ삵Ȃꍇ܂B
*/
class CConvertEndian : public IIrisObject
{
	static const u8	TOP	= 0xAA;
	static const u8	END = 0xEE;
	typedef struct tagData
	{
		u32 size;
		u32 tsize;
		tagData* next;
		tagData(void) : size(0), tsize(0), next(nullptr) {}
		void Clear(void)	{ next = nullptr; size = tsize = 0; }
	} DATA;
public:
	//! endianΉϐ(8bit)
	typedef struct endian8
	{
		// lsȏꍇ삵Ȃ̂
		u8	v;
		endian8(void) : v(0) {}
	} endian8;
	//! endianΉϐ(16bit)
	typedef struct endian16
	{
		iris::endian16	e;
		endian16(void) { e.uv=0; e.byte[0] = TOP; e.byte[1] = END; }	// NX̏̂߂ɒ萔
	} endian16;

	//! endianΉϐ(32bit)
	typedef struct endian32
	{
		iris::endian32	e;
		endian32(void) { e.uv=0; e.byte[0] = TOP; e.byte[3] = END; }	// NX̏̂߂ɒ萔
	} endian32;

	//! endianΉϐ(64bit)
	typedef struct endian64
	{
		iris::endian64	e;
		endian64(void)  { e.uv=0; e.byte[0] = TOP; e.byte[7] = END; }	// NX̏̂߂ɒ萔
	} endian64;

private:
	// f[^Zp[g
	DATA*	m_pList;
public:
	// RXgN^
	CConvertEndian(void);
	CConvertEndian(void* pData, u32 size);
	// fXgN^
	~CConvertEndian(void);

public:
	// f[^Zbg
	void	Release(void);
	// f[^Zbg
	bool	Analysis(void* pData, u32 size);
	// f[^ϊ
	bool	Convert(void* pDst, const void* pSrc);

public:
	// f[^Zbg̑TCY擾
	u32		GetTotalSize(void)	const;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
