//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndConvertEndian.cpp
 * @brief		GfBAϊΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndConvertEndian_CPP_

//======================================================================
// include
#include "FndConvertEndian.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CConvertEndian::CConvertEndian(void)
: m_pList(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pData	= ͑Ώ
 * @param [in]	size	= TCY
*//***********************************************************************/
CConvertEndian::CConvertEndian(void* pData, u32 size)
: m_pList(nullptr)
{
	Analysis(pData, size);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CConvertEndian::~CConvertEndian(void)
{
	Release();
}

/**********************************************************************//**
 *
 * f[^Zbg
 *
*//***********************************************************************/
void CConvertEndian::Release(void)
{
	while( m_pList )
	{
		DATA* p = m_pList;
		m_pList = p->next;
		delete p;
	}
}

/**********************************************************************//**
 *
 * f[^Zbg
 *
 * @note	\̃oCConvertEndian::endian16,32,64ɒuA
 *			ȂǂĂȂԂpDataɓnĂB
 *
 ----------------------------------------------------------------------
 * @param [in]	pData	= ͑Ώ
 * @param [in]	size	= TCY
 * @return	
*//***********************************************************************/
bool CConvertEndian::Analysis(void* pData, u32 size)
{
	if( pData == nullptr ) return false;
	DATA* curr = m_pList;
	u8* p = (u8*)pData;
	u8* ps = nullptr;
	u8* pe = nullptr;
	u8* ps2 = nullptr;
	u32 curr_tsize = 0;
	for( u32 i=0; i < size; ++i, ++p )
	{
		if( ((*p) == TOP) || ((*p) == END) )
		{
			if( ps == nullptr )
			{
				ps = p;	// JnAhXL
				if( ps2 == nullptr ) ps2 = ps;

				if( pe != nullptr )
				{
					// 1bytef[^o
					u32 sz = (u32)(u32w64)p - (u32)(u32w64)pe;
					if( sz > 1 )
					{
						{
							// ܂ł̃f[^Zbg쐬
							DATA* tmp = new DATA;
							tmp->size = (u32)(u32w64)pe - (u32)(u32w64)ps2 + 1;
							tmp->tsize= curr_tsize;
							if( curr == nullptr )	m_pList		= tmp;
							else				curr->next	= tmp;
							curr = tmp;
						}

						{
							// 1bytẽf[^Zbg쐬
							DATA* tmp = new DATA;
							tmp->size = sz-1;
							tmp->tsize= 1;

							ps2 = ps;
							curr_tsize = 0;
							if( curr == nullptr )	m_pList		= tmp;
							else				curr->next	= tmp;
							curr = tmp;
						}
					}
				}
			}
			else
			{
				if( *ps == *p )
				{
					return false;	// gbvlꏏizOȂ̂Ŏsj
				}

				u32 tsize = (u32)(u32w64)p - (u32)(u32w64)ps + 1;
				if(curr_tsize == 0) curr_tsize = tsize;
				if( (curr_tsize != tsize) && (ps != ps2) )
				{
					// ^TCYς̂ŁA܂ł̃f[^Zbg쐬
					DATA* tmp = new DATA;
					tmp->size = (u32)(u32w64)ps - (u32)(u32w64)ps2;
					tmp->tsize= curr_tsize;

					ps2 = ps;
					curr_tsize = tsize;
					if( curr == nullptr )	m_pList		= tmp;
					else				curr->next	= tmp;
					curr = tmp;
				}
				pe = p;
				ps = nullptr;
			}
		}
	}
	if( curr_tsize != 0 )
	{
		// I[f[^Zbg쐬
		DATA* tmp = new DATA;
		tmp->size = (u32)(u32w64)p - (u32)(u32w64)ps2;
		tmp->tsize= curr_tsize;
		if( curr == nullptr )	m_pList		= tmp;
		else				curr->next	= tmp;
		curr = tmp;
	}
	return true;
}

/**********************************************************************//**
 *
 * f[^ϊ
 *
 ----------------------------------------------------------------------
 * @param [out]	pData	= o
 * @param [in]	pSrc	= 
 * @return	
*//***********************************************************************/
bool CConvertEndian::Convert(void* pDst, const void* pSrc)
{
	if( m_pList == nullptr ) return false;
	if( pDst == nullptr ) return false;
	if( pSrc == nullptr ) return false;
	u8* d = (u8*)pDst;
	u8* s = (u8*)pSrc;

	DATA* p = m_pList;
	while(p != nullptr)
	{
		ReversEndian(d, s, p->size, p->tsize);
		d += p->size;
		s += p->size;
		p = p->next;
	}
	return true;
}

/**********************************************************************//**
 *
 * f[^Zbg̑TCY擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
u32 CConvertEndian::GetTotalSize(void)	const
{
	u32 size=0;
	DATA* p = m_pList;
	while(p != nullptr)
	{
		size += p->size;
		p = p->next;
	}
	return size;
}

}	// end of namespace fnd
}	// end of namespace iris
