//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFuzzyVariable.cpp
 * @brief		Fuzzy_ϐNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndFuzzyVariable_CPP_

//======================================================================
// include
#include "FndFuzzyVariable.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
// CFuzzyFuncGrade
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 0
 *			m_X0 <  real <  m_X1	-> 0-1
 *			m_X1 <= real			-> 1
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncGrade::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ZERO);
	if( real >= m_X1 ) fzy = XF32_ONE;
	else if( real > m_X0 )
	{
		xf32 d = m_X1 - m_X0;
		IRIS_ASSERT( d != XF32_ZERO );
		fzy = XF32_Div(real - m_X0, d);
		//fzy = XF32_Div(real, d) - XF32_Div(m_X0, d);
	}
	return fzy;
}

// CFuzzyFuncReverseGrade
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 1
 *			m_X0 <  real <  m_X1	-> 1-0
 *			m_X1 <= real			-> 0
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncReverseGrade::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ONE);
	if( real >= m_X1 ) fzy = XF32_ZERO;
	else if( real > m_X0 )
	{
		xf32 d = m_X1 - m_X0;
		IRIS_ASSERT( d != XF32_ZERO );
		fzy = XF32_Div(m_X1 - real, d);
		//fzy = XF32_Div(m_X1, d) - XF32_Div(real, d);
	}
	return fzy;
}

// CFuzzyFuncTriangle
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 0
 *			m_X0 <  real <  m_X1	-> 0-1
 *			real == m_X1			-> 1
 *			m_X1 <  real <  m_X2	-> 1-0
 *			m_X2 <= real			-> 0
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncTriangle::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ZERO);
	if( m_X0 <= real && real <= m_X2 )
	{
		if( real == m_X1 ) fzy = XF32_ONE;
		else
		{
			if( real < m_X1 )
			{
				xf32 d = m_X1 - m_X0;
				if( d == XF32_ZERO )	fzy = XF32_ONE;
				else					fzy = XF32_Div(real - m_X0, d);
				//else					fzy = XF32_Div(real, d) - XF32_Div(m_X0, d);
			}
			else
			{
				xf32 d = m_X2 - m_X1;
				if( d == XF32_ZERO )	fzy = XF32_ONE;
				else					fzy = XF32_Div(m_X2 - real, d);
				//else					fzy = XF32_Div(m_X2, d) - XF32_Div(real, d);
			}
		}
	}
	return fzy;
}

// CFuzzyFuncTrapezoid
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 0
 *			m_X0 <  real <  m_X1	-> 0-1
 *			m_X1 <= real <= m_X2	-> 1
 *			m_X2 <  real <  m_X3	-> 1-0
 *			m_X3 <= real			-> 0
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncTrapezoid::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ZERO);
	if( m_X0 <= real && real <= m_X3 )
	{
		if( m_X1 <= real && real <= m_X2 ) fzy = XF32_ONE;
		else
		{
			if( real < m_X1 )
			{
				xf32 d = m_X1 - m_X0;
				if( d == XF32_ZERO )	fzy = XF32_ONE;
				else					fzy = XF32_Div(real - m_X0, d);
				//else					fzy = XF32_Div(real, d) - XF32_Div(m_X0, d);
			}
			else
			{
				xf32 d = m_X3 - m_X2;
				if( d == XF32_ZERO )	fzy = XF32_ONE;
				else					fzy = XF32_Div(m_X3 - real, d);
				//else					fzy = XF32_Div(m_X3, d) - XF32_Div(real, d);
			}
		}
	}
	return fzy;
}

// CFuzzyFuncRiseBool
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 0
 *			m_X0 <  real			-> 1
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncRiseBool::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ZERO);
	if( real > m_X0 ) fzy = XF32_ONE;
	return fzy;
}

// CFuzzyFuncFallBool
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 1
 *			m_X0 <  real			-> 0
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncFallBool::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ONE);
	if( real > m_X0 ) fzy = XF32_ZERO;
	return fzy;
}

// CFuzzyFuncRectBool
/**********************************************************************//**
 *
 * Fuzzyl̐
 *
 ----------------------------------------------------------------------
 * @param [in]	real	= 
 * @return	Fuzzyϐ
 *			real <= m_X0			-> 0
 *			m_X0 <  real <  m_X1	-> 1
 *			m_X0 <= real			-> 0
*//***********************************************************************/
CFuzzyVariable CFuzzyFuncRectBool::Calc(xf32 real)
{
	CFuzzyVariable fzy(XF32_ZERO);
	if( real > m_X0 && real < m_X1 ) fzy = XF32_ONE;
	return fzy;
}

}	// end of namespace fnd
}	// end of namespace iris
