//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDrawer.h
 * @brief		Drawert@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndDrawer_H_
#define INCG_IRIS_FndDrawer_H_

#include "../../iris_object.h"
#include "../../iris_xf.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// `IuWFNg
class IDrawer : public IIrisObject
{
private:
	xf32	m_SortKey;
public:
	/// RXgN^
	IDrawer(void) : m_SortKey(XF32_ZERO) {}
	/// fXgN^
	virtual ~IDrawer(void)	{}
public:
	/// `
	virtual void	Draw(void)	= 0;

public:
	/**
	 * @brief	\[gL[̐ݒ
	 * @param [in] key	= \[gL[
	*/
	virtual void	SetSortKey(xf32 key)		{ m_SortKey = key; }

	/**
	 * @brief	\[gL[̎擾
	 * @return \[gL[
	*/
	virtual xf32	GetSortKey(void)	const	{ return m_SortKey; }

public:
	// \[gpoperator
	s32		operator == (const IDrawer& drawer) const
	{
		return (m_SortKey == drawer.m_SortKey);
	}

	s32		operator != (const IDrawer& drawer) const
	{
		return (m_SortKey != drawer.m_SortKey);
	}

	s32		operator < (const IDrawer& drawer) const
	{
		return (m_SortKey < drawer.m_SortKey);
	}

	s32		operator > (const IDrawer& drawer) const
	{
		return (m_SortKey > drawer.m_SortKey);
	}

	s32		operator <= (const IDrawer& drawer) const
	{
		return (m_SortKey <= drawer.m_SortKey);
	}

	s32		operator >= (const IDrawer& drawer) const
	{
		return (m_SortKey >= drawer.m_SortKey);
	}

};


}	// end of namespace fnd
}	// end of namespace iris

#endif
