//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDelayVariable.h
 * @brief		xϐNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndDelayVariable_H_
#define INCG_IRIS_FndDelayVariable_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_xf.h"

#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	xϐNX
 * @tparam	_TN	= Ώی^
*/
template<typename _TN>
class CDelayVariable : public IIrisObject
{
	typedef CDelayVariable<_TN>	_Myt;
public:
	typedef _TN		value_type;	//!< ^
	typedef typename ::cpp0x::arg_type<_TN>::type arg_type;	//!< ^

private:
	value_type	m_Value0;	//!< l
	value_type	m_Value1;	//!< zl
	xf32		m_Delay;	//!< xp[^
public:
	/// RXgN^
	CDelayVariable(void)
	: m_Delay(XF32_ZERO)
	{ m_Value0 = m_Value1 = m_Value0-m_Value0; }
	/// RXgN^
	explicit CDelayVariable(arg_type v, xf32 d=XF32_ZERO)
	: m_Delay(d)
	{
		Reset(v);
		if( m_Delay < XF32_ZERO )		m_Delay = XF32_ZERO;
		else if( m_Delay > XF32_ONE )	m_Delay = XF32_ONE;
	}

public:
	/// l̃Zbg
	void	Reset(arg_type v)			{ m_Value0 = m_Value1 = v; }
	/// ~bg
	void	Limit(arg_type ll, arg_type lu)
	{
		if(m_Value1 < ll) m_Value1 = ll; else if(m_Value1 > lu) m_Value1 = lu;
		if(m_Delay==XF32_ZERO) m_Value0 = m_Value1;
	}
	/// XV
	void	Update(void)
	{
#if	IRIS_XF_FIXED_FLOAT
		if( ::cpp0x::is_xf_traits<_TN>::value )
		{
			//m_Value0 = XF32_Mul(m_Value0, m_Delay) + XF32_Mul(m_Value1, (XF32_ONE - m_Delay));
		}
		else
#endif
		m_Value0 = m_Value0 * m_Delay + m_Value1 * (XF32_ONE - m_Delay);
	}

public:
	/// xl̕ύX
	void		SetDelay(xf32 delay)		{ m_Delay = delay; }
	/// xl̎擾
	xf32		GetDelay(void)	const		{ return m_Delay; }
	/// l̎擾
	value_type	GetValue(void)	const		{ return m_Value0; }
	/// l̐ݒ
	void		SetValue(arg_type val)		{ m_Value1  = val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }

	/// Z
	void		AddValue(arg_type val)		{ m_Value1 += val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }
	/// Z
	void		SubValue(arg_type val)		{ m_Value1 -= val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }
	/// Z
	void		MulValue(arg_type val)		{ m_Value1 *= val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }
	/// Z
	void		DivValue(arg_type val)		{ m_Value1 /= val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }
	/// ]
	void		RemValue(arg_type val)		{ m_Value1 %= val; if(m_Delay==XF32_ZERO) m_Value0 = m_Value1; }

public:
	// operator
	/// 
	_Myt&	operator  = (arg_type val)	{ SetValue(val); return *this; }
	/// Z
	_Myt&	operator += (arg_type val)	{ AddValue(val); return *this; }
	/// Z
	_Myt&	operator -= (arg_type val)	{ SubValue(val); return *this; }
	/// Z
	_Myt&	operator *= (arg_type val)	{ MulValue(val); return *this; }
	/// Z
	_Myt&	operator /= (arg_type val)	{ DivValue(val); return *this; }
	/// ]
	_Myt&	operator %= (arg_type val)	{ RemValue(val); return *this; }

	bool	operator ==	(const _Myt& rhs) const	{ return GetValue() == rhs.GetValue(); }
	bool	operator !=	(const _Myt& rhs) const	{ return GetValue() != rhs.GetValue(); }
	bool	operator <	(const _Myt& rhs) const	{ return GetValue() < rhs.GetValue(); }
	bool	operator <=	(const _Myt& rhs) const	{ return GetValue() <= rhs.GetValue(); }
	bool	operator >	(const _Myt& rhs) const	{ return GetValue() > rhs.GetValue(); }
	bool	operator >=	(const _Myt& rhs) const	{ return GetValue() >= rhs.GetValue(); }

	/// LXg
	operator	value_type	(void)		{ return GetValue(); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
