//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndBootArg.h
 * @brief		N̎擾VXe t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndBootArg_H_
#define INCG_IRIS_FndBootArg_H_

//======================================================================
// include
#include "../container/FndSingleton.h"
#include "../../iris_tchar.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	N擾pNX
*/
class CBootArgument : public CSingleton<CBootArgument>
{
	typedef CSingleton<CBootArgument>	_Mybase;
public:
	static CBootArgument&	GetInstance(void)	
	{
		if( GetInstancePtr() == nullptr )
		{
			static CBootArgument def;
			return def;
		}
		return _Mybase::GetInstance();
	}

	static int			GetArgc(void)		{ return GetInstance().GetArgc_(); }
	static const TCHAR* GetArgv(int index)	{ return GetInstance().GetArgv_(index); }

private:
	// argc
	virtual int	GetArgc_(void) const
	{
#ifdef _WIN32
		return ::__argc;
#else
		return 0; 
#endif
	}
	// argc
	virtual const TCHAR* GetArgv_(int index) const
	{
#ifdef _WIN32
		return ::__targv[index];
#else
		IRIS_UNUSED_VAR(index);
		return nullptr;
#endif
	}
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
