//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndScene.h
 * @brief		V[ǗNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndScene_H_
#define INCG_IRIS_FndScene_H_

//======================================================================
// include
#include "FndLayer.h"
#include "../../iris_xf.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// V[ǗNX
class CScene : public IIrisObject
{
protected:
	CUpdateCollector	m_PreUpdate;
	CUpdateCollector	m_Update;
	CUpdateCollector	m_PostUpdate;
	CList<CDrawLayer>	m_Layer;
public:
	// RXgN^
	CScene(void);
	// fXgN^
	~CScene(void);

public:
	// C[̒ǉ
	void		AddLayer(CDrawLayer* layer);
	// C[̑}
	void		InsertLayer(s32 layer_id, CDrawLayer* layer);
	// C[̍폜
	void		EraseLayer(s32 layer_id);
	void		EraseLayer(CDrawLayer* layer);

	// C[̎擾
	CDrawLayer*	GetLayer(s32 layer_id);

public:
	// o^
	void		RegistPreUpdater(CUpdateNode* node);
	void		RegistUpdater(CUpdateNode* node);
	void		RegistPostUpdater(CUpdateNode* node);
	void		RegistDrawer(s32 layer_id, CDrawNode* node);

	// 폜
	void		ErasePreUpdater(CUpdateNode* node);
	void		EraseUpdater(CUpdateNode* node);
	void		ErasePostUpdater(CUpdateNode* node);
	void		EraseDrawer(s32 layer_id, CDrawNode* node);

public:
	// XVO
	void		PreUpdate(xf32 time);
	// XV
	void		Update(xf32 time);
	// XV㏈
	void		PostUpdate(xf32 time);
	// `
	void		Draw(void);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
