//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMemBuffer.cpp
 * @brief		obt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndMemBuffer_CPP_

//======================================================================
// include
#include "FndMemBuffer.h"
#include "FndMemory.h"

#ifdef _WIN32
#include "../../platform/windows/win/debug/WXDebugLeakCheckMacro.h"
#endif

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMemBuffer::CMemBuffer(void)
: m_pBuffer(nullptr)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMemBuffer::~CMemBuffer(void)
{
	Dealloc();
}

/**********************************************************************//**
 *
 * m
 *
 ----------------------------------------------------------------------
 * @param [in]	size	= mۂTCY
 * @param [in]	arg		= new 
*//***********************************************************************/
void CMemBuffer::Alloc(u32 size, s32 arg)
{
	Dealloc();

	m_pBuffer = irisAlloc(size, arg);
	m_Size = size;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CMemBuffer::Dealloc(void)
{
	if( m_pBuffer != nullptr )
	{
		irisFree(m_pBuffer);
		m_pBuffer = nullptr;
	}
}

}	// end of namespace fnd
}	// end of namespace iris
