//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFile.h
 * @brief		FILENXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndIFile_H_
#define INCG_IRIS_FndIFile_H_

//======================================================================
// include
#include "FndIStream.h"
#include "../../c++0x/cpp0x_enable_if.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace fnd
{

//======================================================================
// enum
/// Open [h
typedef enum
{
	FOPEN_READ		= 0x00000001,	//!< ǂݍ
	FOPEN_WRITE		= 0x00000002,	//!< 
	FOPEN_RW		= FOPEN_READ|FOPEN_WRITE,	//!< ǂݏ
	FOPEN_NONBLOCK	= 0x00000004,	//!< non blocking [h
	FOPEN_READLOCK	= 0x00000010,	//!< ǂݍ݃bN( non shared )
	FOPEN_WRITELOCK	= 0x00000020,	//!< ݃bN( non shared )
	FOPEN_APPEND	= 0x00000100,	//!< ǉ݃[h
	FOPEN_CREATE	= 0x00000200,	//!< t@CȂƂɍ쐬
	FOPEN_TRUNC		= 0x00000400,	//!< ej(0byte)ĊJ
	FOPEN_CREATENEW	= 0x00000800,	//!< FOPEN_CREATEw肵ƂɁAt@C݂ƃG[Ƃ
	FOPEN_EXCL		= 0x01000000,	//!< t@CI[vXbĥݑ싖
	FOPEN_POWERLOCK	= 0x02000000,	//!< t@C쒆̓d֎~
	FOPEN_MASK		= 0x03000f37
} OPEN_MODE;
/// seek[h
typedef enum
{
	FILE_SEEK_SET = 0,	//!< 擪
	FILE_SEEK_CUR,		//!< Jgʒu
	FILE_SEEK_END,		//!< I[
	FILE_SEEK_MODE_NUM
} SEEK_MODE;

//======================================================================
// class
//! FILENX C^[tFCX
class IFile : private IStream
{
public:
	// RXgN^
	IFile(void)				{}
	// fXgN^
	virtual ~IFile(void)	{}
public:
	// J

	template<typename CHARTYPE_>
	bool Open(const CHARTYPE_* lpFileName, u32 mode, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR> >::type*& =cpp0x::enabler::value)	{ return OpenA(lpFileName, mode); }
	template<typename CHARTYPE_>
	bool Open(const CHARTYPE_* lpFileName, u32 mode, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler::value)	{ return OpenW(lpFileName, mode); }

	virtual bool	OpenA(LPCSTR  lpFileName, u32 mode)	= 0;
	virtual bool	OpenW(LPCWSTR lpFileName, u32 mode)	= 0;
	virtual bool	IsOpen(void)	const	= 0;
	/**
	 * 
	 * @return	
	*/
	virtual bool	Close(void)	= 0;
	/**
	 * seek
	 * @param [in]	offset	= ItZbg
	 * @param [in]	origin	= vZ@
	 * @return	
	*/
	virtual bool	Seek(long offset, int origin)	= 0;
	/**
	 * tell
	 * @return	݂̃t@Cʒu
	*/
	virtual s32		Tell(void)		const	= 0;
	/**
	 * t@CTCY擾
	 * @return t@CTCYioCgPʁj
	*/
	virtual u32		GetSize(void)	const	= 0;

	/**
	 * ǂݍ
	 * @param [out]	buf		= o̓obt@
	 * @param [in]	size	= o̓obt@TCY
	 * @return	ǂݍ݃TCY
	*/
	virtual u32		Read(void* buf, u32 size)		= 0;
	virtual u32		ReadAsync(void* buf, u32 size)	= 0;
	/**
	 * 
	 * @param [in]	buf		= ̓obt@
	 * @param [in]	size	= ̓obt@TCY
	 * @return	݃TCY
	*/
	virtual u32		Write(const void* buf, u32 size)		= 0;
	virtual u32		WriteAsync(const void* buf, u32 size)	= 0;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
