//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndDeviceIO.h
 * @brief		Device IONXC^[tF[X t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndDeviceIO_H_
#define INCG_IRIS_FndDeviceIO_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! FILENX C^[tFCX
class IDeviceIO : private INonCopyable<IDeviceIO>
{
public:
	bool	IoControl(u32 dwIoControlCode, LPVOID lpInBuffer=nullptr, u32 nInBufferSize=0) const
	{
		u32 dwRead=0;
		return OnIoControl(dwIoControlCode, lpInBuffer, nInBufferSize, nullptr, 0, &dwRead);
	}
	bool	IoControl(u32 dwIoControlCode, LPVOID lpInBuffer, u32 nInBufferSize
						, LPVOID lpOutBuffer, u32 nOutBufferSize, u32* lpBytesReturned) const
	{
		return OnIoControl(dwIoControlCode, lpInBuffer, nInBufferSize, lpOutBuffer, nOutBufferSize, lpBytesReturned);
	}

protected:
	virtual bool	OnIoControl(u32 dwIoControlCode, LPVOID lpInBuffer, u32 nInBufferSize
						, LPVOID lpOutBuffer, u32 nOutBufferSize, u32* lpBytesReturned) const = 0;
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
